/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import java.util.Objects;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.util.LeafsetEntryInterner;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;

final class InterningLeafSetNodeBuilder<T>
extends ImmutableLeafSetNodeBuilder<T> {
    private final LeafsetEntryInterner interner;

    private InterningLeafSetNodeBuilder(LeafsetEntryInterner interner) {
        this.interner = Objects.requireNonNull(interner);
    }

    private InterningLeafSetNodeBuilder(LeafsetEntryInterner interner, int sizeHint) {
        super(sizeHint);
        this.interner = Objects.requireNonNull(interner);
    }

    private static LeafsetEntryInterner getInterner(DataSchemaNode schema) {
        return schema instanceof LeafSetNode ? LeafsetEntryInterner.forSchema((LeafListSchemaNode)((LeafListSchemaNode)schema)) : null;
    }

    static <T> ListNodeBuilder<T, LeafSetEntryNode<T>> create(DataSchemaNode schema) {
        LeafsetEntryInterner interner = InterningLeafSetNodeBuilder.getInterner(schema);
        if (interner != null) {
            return new InterningLeafSetNodeBuilder<T>(interner);
        }
        return ImmutableLeafSetNodeBuilder.create();
    }

    static <T> ListNodeBuilder<T, LeafSetEntryNode<T>> create(DataSchemaNode schema, int sizeHint) {
        LeafsetEntryInterner interner = InterningLeafSetNodeBuilder.getInterner(schema);
        if (interner != null) {
            return new InterningLeafSetNodeBuilder<T>(interner, sizeHint);
        }
        return ImmutableLeafSetNodeBuilder.create(sizeHint);
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChild(LeafSetEntryNode<T> child) {
        return super.withChild(this.interner.intern(child));
    }
}

