/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;

public final class ImmutableLeafSetNodeSchemaAwareBuilder<T>
extends ImmutableLeafSetNodeBuilder<T> {
    private final LeafListSchemaNode schema;

    private ImmutableLeafSetNodeSchemaAwareBuilder(LeafListSchemaNode schema) {
        this.schema = Objects.requireNonNull(schema);
        super.withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()));
    }

    public ImmutableLeafSetNodeSchemaAwareBuilder(LeafListSchemaNode schema, ImmutableLeafSetNodeBuilder.ImmutableLeafSetNode<T> node) {
        super(node);
        this.schema = Objects.requireNonNull(schema);
        super.withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()));
    }

    public static <T> @NonNull ListNodeBuilder<T, LeafSetEntryNode<T>> create(LeafListSchemaNode schema) {
        return new ImmutableLeafSetNodeSchemaAwareBuilder<T>(schema);
    }

    public static <T> @NonNull ListNodeBuilder<T, LeafSetEntryNode<T>> create(LeafListSchemaNode schema, LeafSetNode<T> node) {
        if (!(node instanceof ImmutableLeafSetNodeBuilder.ImmutableLeafSetNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableLeafSetNodeSchemaAwareBuilder<T>(schema, (ImmutableLeafSetNodeBuilder.ImmutableLeafSetNode)node);
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChildValue(T childValue) {
        return super.withChildValue(childValue);
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChild(LeafSetEntryNode<T> child) {
        Preconditions.checkArgument((boolean)this.schema.getQName().equals((Object)child.getNodeType()), (String)"Incompatible node type, should be: %s, is: %s", (Object)this.schema.getQName(), (Object)child.getNodeType());
        DataValidationException.checkLegalChild(this.schema.getQName().equals((Object)child.getNodeType()), (YangInstanceIdentifier.PathArgument)child.getIdentifier(), (DataSchemaNode)this.schema, Collections.singleton(this.schema.getQName()));
        return super.withChild(child);
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }
}

