/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.AbstractImmutableDataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableDataContainerNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableMapEntryNodeBuilder
extends AbstractImmutableDataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> {
    private static final Logger LOG = LoggerFactory.getLogger(ImmutableMapEntryNodeBuilder.class);
    protected final Map<QName, YangInstanceIdentifier.PathArgument> childrenQNamesToPaths;

    protected ImmutableMapEntryNodeBuilder() {
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.PathArgument>();
    }

    protected ImmutableMapEntryNodeBuilder(int sizeHint) {
        super(sizeHint);
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.PathArgument>(sizeHint);
    }

    protected ImmutableMapEntryNodeBuilder(ImmutableMapEntryNode node) {
        super(node);
        this.childrenQNamesToPaths = new LinkedHashMap<QName, YangInstanceIdentifier.PathArgument>();
        ImmutableMapEntryNodeBuilder.fillQnames(node.getValue(), this.childrenQNamesToPaths);
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create() {
        return new ImmutableMapEntryNodeBuilder();
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create(int sizeHint) {
        return new ImmutableMapEntryNodeBuilder(sizeHint);
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> create(MapEntryNode node) {
        if (!(node instanceof ImmutableMapEntryNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableMapEntryNodeBuilder((ImmutableMapEntryNode)node);
    }

    private static void fillQnames(Iterable<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> iterable, Map<QName, YangInstanceIdentifier.PathArgument> out) {
        for (DataContainerChild<YangInstanceIdentifier.PathArgument, ?> dataContainerChild : iterable) {
            YangInstanceIdentifier.PathArgument identifier = dataContainerChild.getIdentifier();
            if (ImmutableMapEntryNodeBuilder.isAugment(identifier)) continue;
            out.put(dataContainerChild.getNodeType(), identifier);
        }
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withValue(Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> withValue) {
        ImmutableMapEntryNodeBuilder.fillQnames(withValue, this.childrenQNamesToPaths);
        return super.withValue((Collection)withValue);
    }

    private static boolean isAugment(YangInstanceIdentifier.PathArgument identifier) {
        return identifier instanceof YangInstanceIdentifier.AugmentationIdentifier;
    }

    @Override
    public DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> withChild(DataContainerChild<?, ?> child) {
        if (!ImmutableMapEntryNodeBuilder.isAugment(child.getIdentifier())) {
            this.childrenQNamesToPaths.put(child.getNodeType(), child.getIdentifier());
        }
        return super.withChild(child);
    }

    @Override
    public MapEntryNode build() {
        for (Map.Entry key : ((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier()).getKeyValues().entrySet()) {
            DataContainerChild<YangInstanceIdentifier.PathArgument, ?> childNode = this.getChild(this.childrenQNamesToPaths.get(key.getKey()));
            if (childNode == null) {
                LeafNode leaf = ImmutableNodes.leafNode((QName)key.getKey(), key.getValue());
                LOG.debug("Adding leaf {} implied by key {}", leaf, key);
                this.withChild((DataContainerChild<?, ?>)leaf);
                continue;
            }
            DataValidationException.checkListKey((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier(), (QName)key.getKey(), key.getValue(), childNode.getValue());
        }
        return new ImmutableMapEntryNode((YangInstanceIdentifier.NodeIdentifierWithPredicates)this.getNodeIdentifier(), this.buildValue());
    }

    private static final class ImmutableMapEntryNode
    extends AbstractImmutableDataContainerNode<YangInstanceIdentifier.NodeIdentifierWithPredicates>
    implements MapEntryNode {
        ImmutableMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates nodeIdentifier, Map<YangInstanceIdentifier.PathArgument, DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> children) {
            super(children, nodeIdentifier);
        }
    }
}

