/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;

public class ImmutableMapNodeBuilder
implements CollectionNodeBuilder<MapEntryNode, MapNode> {
    private static final int DEFAULT_CAPACITY = 4;
    private final Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;

    protected ImmutableMapNodeBuilder() {
        this.value = new HashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
    }

    protected ImmutableMapNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? Maps.newHashMapWithExpectedSize((int)sizeHint) : new HashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
    }

    protected ImmutableMapNodeBuilder(ImmutableMapNode node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = MapAdaptor.getDefaultInstance().takeSnapshot(node.children);
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, MapNode> create() {
        return new ImmutableMapNodeBuilder();
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, MapNode> create(int sizeHint) {
        return new ImmutableMapNodeBuilder(sizeHint);
    }

    public static CollectionNodeBuilder<MapEntryNode, MapNode> create(MapNode node) {
        if (!(node instanceof ImmutableMapNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableMapNodeBuilder((ImmutableMapNode)node);
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, MapNode> withChild(MapEntryNode child) {
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, MapNode> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.value.remove(key);
        return this;
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, MapNode> withValue(Collection<MapEntryNode> withValue) {
        for (MapEntryNode mapEntryNode : withValue) {
            this.withChild(mapEntryNode);
        }
        return this;
    }

    @Override
    public CollectionNodeBuilder<MapEntryNode, MapNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    @Override
    public MapNode build() {
        return new ImmutableMapNode(this.nodeIdentifier, MapAdaptor.getDefaultInstance().optimize(this.value));
    }

    public CollectionNodeBuilder<MapEntryNode, MapNode> addChild(MapEntryNode child) {
        return this.withChild(child);
    }

    @Override
    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, MapEntryNode, MapNode> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableMapNode
    extends AbstractImmutableNormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<MapEntryNode>>
    implements MapNode {
        private final Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children;

        ImmutableMapNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children) {
            super(nodeIdentifier);
            this.children = children;
        }

        public Optional<MapEntryNode> getChild(YangInstanceIdentifier.NodeIdentifierWithPredicates child) {
            return Optional.ofNullable(this.children.get(child));
        }

        public Collection<MapEntryNode> getValue() {
            return UnmodifiableCollection.create(this.children.values());
        }

        @Override
        protected int valueHashCode() {
            return this.children.hashCode();
        }

        @Override
        protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
            return this.children.equals(((ImmutableMapNode)other).children);
        }
    }
}

