/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.StructuralContainerModificationStrategy;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;

class ContainerModificationStrategy
extends DataNodeContainerModificationStrategy<ContainerSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, ContainerNode> SUPPORT = new NormalizedNodeContainerSupport(ContainerNode.class, ImmutableContainerNodeBuilder::create, ImmutableContainerNodeBuilder::create);

    ContainerModificationStrategy(ContainerSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        super(SUPPORT, schemaNode, treeConfig);
    }

    static ModificationApplyOperation of(ContainerSchemaNode schema, DataTreeConfiguration treeConfig) {
        if (schema.isPresenceContainer()) {
            Optional<MandatoryLeafEnforcer> enforcer = MandatoryLeafEnforcer.forContainer((DataNodeContainer)schema, treeConfig);
            return enforcer.isPresent() ? new EnforcingMandatory(schema, treeConfig, enforcer.get()) : new ContainerModificationStrategy(schema, treeConfig);
        }
        return new StructuralContainerModificationStrategy(schema, treeConfig);
    }

    private static final class EnforcingMandatory
    extends ContainerModificationStrategy {
        private final MandatoryLeafEnforcer enforcer;

        EnforcingMandatory(ContainerSchemaNode schemaNode, DataTreeConfiguration treeConfig, MandatoryLeafEnforcer enforcer) {
            super(schemaNode, treeConfig);
            this.enforcer = Objects.requireNonNull(enforcer);
        }

        @Override
        void mandatoryVerifyValueChildren(NormalizedNode<?, ?> writtenValue) {
            this.enforcer.enforceOnData(writtenValue);
        }

        @Override
        protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
            TreeNode ret = super.applyMerge(modification, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }

        @Override
        protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode<?, ?> newValue, Optional<TreeNode> currentMeta, Version version) {
            TreeNode ret = super.applyWrite(modification, newValue, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }

        @Override
        protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
            TreeNode ret = super.applyTouch(modification, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }
    }
}

