/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

class ListEntryModificationStrategy
extends DataNodeContainerModificationStrategy<ListSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> SUPPORT = new NormalizedNodeContainerSupport(MapEntryNode.class, ImmutableMapEntryNodeBuilder::create, ImmutableMapEntryNodeBuilder::create);

    ListEntryModificationStrategy(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        super(SUPPORT, schema, treeConfig);
    }

    static @NonNull ListEntryModificationStrategy of(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        Optional<MandatoryLeafEnforcer> enforcer = MandatoryLeafEnforcer.forContainer((DataNodeContainer)schema, treeConfig);
        return enforcer.isPresent() ? new EnforcingMandatory(schema, treeConfig, enforcer.get()) : new ListEntryModificationStrategy(schema, treeConfig);
    }

    private static final class EnforcingMandatory
    extends ListEntryModificationStrategy {
        private final MandatoryLeafEnforcer enforcer;

        EnforcingMandatory(ListSchemaNode schemaNode, DataTreeConfiguration treeConfig, MandatoryLeafEnforcer enforcer) {
            super(schemaNode, treeConfig);
            this.enforcer = Objects.requireNonNull(enforcer);
        }

        @Override
        void mandatoryVerifyValueChildren(NormalizedNode<?, ?> writtenValue) {
            this.enforcer.enforceOnData(writtenValue);
        }

        @Override
        protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
            TreeNode ret = super.applyMerge(modification, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }

        @Override
        protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode<?, ?> newValue, Optional<TreeNode> currentMeta, Version version) {
            TreeNode ret = super.applyWrite(modification, newValue, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }

        @Override
        protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
            TreeNode ret = super.applyTouch(modification, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }
    }
}

