/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraintAware;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MandatoryLeafEnforcer
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(MandatoryLeafEnforcer.class);
    private final ImmutableList<YangInstanceIdentifier> mandatoryNodes;

    private MandatoryLeafEnforcer(ImmutableList<YangInstanceIdentifier> mandatoryNodes) {
        this.mandatoryNodes = Objects.requireNonNull(mandatoryNodes);
    }

    static Optional<MandatoryLeafEnforcer> forContainer(DataNodeContainer schema, DataTreeConfiguration treeConfig) {
        if (!treeConfig.isMandatoryNodesValidationEnabled()) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        MandatoryLeafEnforcer.findMandatoryNodes((ImmutableList.Builder<YangInstanceIdentifier>)builder, YangInstanceIdentifier.EMPTY, schema, treeConfig.getTreeType());
        ImmutableList mandatoryNodes = builder.build();
        return mandatoryNodes.isEmpty() ? Optional.empty() : Optional.of(new MandatoryLeafEnforcer((ImmutableList<YangInstanceIdentifier>)mandatoryNodes));
    }

    void enforceOnData(NormalizedNode<?, ?> data) {
        for (YangInstanceIdentifier id : this.mandatoryNodes) {
            Preconditions.checkArgument((boolean)NormalizedNodes.findNode(data, (YangInstanceIdentifier)id).isPresent(), (String)"Node %s is missing mandatory descendant %s", (Object)data.getIdentifier(), (Object)id);
        }
    }

    void enforceOnTreeNode(TreeNode tree) {
        this.enforceOnData(tree.getData());
    }

    private static void findMandatoryNodes(ImmutableList.Builder<YangInstanceIdentifier> builder, YangInstanceIdentifier id, DataNodeContainer schema, TreeType type) {
        for (DataSchemaNode child : schema.getChildNodes()) {
            boolean needEnforce;
            if (!SchemaAwareApplyOperation.belongsToTree(type, child)) continue;
            if (child instanceof ContainerSchemaNode) {
                ContainerSchemaNode container = (ContainerSchemaNode)child;
                if (container.isPresenceContainer()) continue;
                MandatoryLeafEnforcer.findMandatoryNodes(builder, id.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)child.getQName())), (DataNodeContainer)container, type);
                continue;
            }
            boolean bl = needEnforce = child instanceof MandatoryAware && ((MandatoryAware)child).isMandatory();
            if (!needEnforce && child instanceof ElementCountConstraintAware) {
                needEnforce = ((ElementCountConstraintAware)child).getElementCountConstraint().map(constraint -> {
                    Integer min = constraint.getMinElements();
                    return min != null && min > 0;
                }).orElse(Boolean.FALSE);
            }
            if (!needEnforce) continue;
            YangInstanceIdentifier childId = id.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)child.getQName()));
            LOG.debug("Adding mandatory child {}", (Object)childId);
            builder.add((Object)childId.toOptimized());
        }
    }
}

