/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.api.codec.EmptyCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;

final class EmptyStringCodec
extends TypeDefinitionAwareCodec<Empty, EmptyTypeDefinition>
implements EmptyCodec<String> {
    static final EmptyStringCodec INSTANCE = new EmptyStringCodec();

    private EmptyStringCodec() {
        super(Optional.empty(), Empty.class);
    }

    @Override
    public String serialize(Empty data) {
        Objects.requireNonNull(data);
        return "";
    }

    @Override
    public Empty deserialize(String stringRepresentation) {
        Preconditions.checkArgument((boolean)stringRepresentation.isEmpty(), (Object)"The value must be empty");
        return Empty.getInstance();
    }
}

