/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaUtils;
import org.opendaylight.yangtools.yang.model.api.AnyDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class SchemaTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaTracker.class);
    private final Deque<DocumentedNode.WithStatus> schemaStack = new ArrayDeque<DocumentedNode.WithStatus>();
    private final DataNodeContainer root;

    private SchemaTracker(DataNodeContainer root) {
        this.root = Objects.requireNonNull(root);
    }

    public static @NonNull SchemaTracker create(DataNodeContainer root) {
        return new SchemaTracker(root);
    }

    public static @NonNull SchemaTracker create(SchemaContext context, SchemaPath path) {
        Collection<SchemaNode> schemaNodes = SchemaUtils.findParentSchemaNodesOnPath(context, path);
        Preconditions.checkArgument((!schemaNodes.isEmpty() ? 1 : 0) != 0, (String)"Unable to find schema node for supplied schema path: %s", (Object)path);
        if (schemaNodes.size() > 1) {
            LOG.warn("More possible schema nodes {} for supplied schema path {}", schemaNodes, (Object)path);
        }
        Optional<DataNodeContainer> current = schemaNodes.stream().filter(node -> node instanceof DataNodeContainer).map(DataNodeContainer.class::cast).findFirst();
        Preconditions.checkArgument((boolean)current.isPresent(), (String)"Schema path must point to container or list or an rpc input/output. Supplied path %s pointed to: %s", (Object)path, current);
        return new SchemaTracker(current.get());
    }

    public Object getParent() {
        if (this.schemaStack.isEmpty()) {
            return this.root;
        }
        return this.schemaStack.peek();
    }

    private SchemaNode getSchema(YangInstanceIdentifier.PathArgument name) {
        Object parent = this.getParent();
        DataSchemaNode schema = null;
        QName qname = name.getNodeType();
        if (parent instanceof DataNodeContainer) {
            schema = ((DataNodeContainer)parent).getDataChildByName(qname);
            if (schema == null) {
                if (parent instanceof GroupingDefinition) {
                    schema = (GroupingDefinition)parent;
                } else if (parent instanceof NotificationDefinition) {
                    schema = (NotificationDefinition)parent;
                }
            }
        } else if (parent instanceof ChoiceSchemaNode) {
            schema = SchemaTracker.findChildInCases((ChoiceSchemaNode)parent, qname);
        } else {
            throw new IllegalStateException("Unsupported schema type " + parent.getClass() + " on stack.");
        }
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Could not find schema for node %s in %s", (Object)qname, (Object)parent);
        return schema;
    }

    private static SchemaNode findChildInCases(ChoiceSchemaNode parent, QName qname) {
        for (CaseSchemaNode caze : parent.getCases().values()) {
            Optional potential = caze.findDataChildByName(qname);
            if (!potential.isPresent()) continue;
            return (SchemaNode)potential.get();
        }
        return null;
    }

    private static SchemaNode findCaseByChild(ChoiceSchemaNode parent, QName qname) {
        for (CaseSchemaNode caze : parent.getCases().values()) {
            Optional potential = caze.findDataChildByName(qname);
            if (!potential.isPresent()) continue;
            return caze;
        }
        return null;
    }

    public void startList(YangInstanceIdentifier.PathArgument name) {
        SchemaNode schema = this.getSchema(name);
        Preconditions.checkArgument((boolean)(schema instanceof ListSchemaNode), (String)"Node %s is not a list", (Object)schema.getPath());
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
    }

    public void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        Object schema = this.getParent();
        Preconditions.checkArgument((boolean)(schema instanceof ListSchemaNode), (Object)"List item is not appropriate");
        this.schemaStack.push((DocumentedNode.WithStatus)((ListSchemaNode)schema));
    }

    public LeafSchemaNode leafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        SchemaNode schema = this.getSchema((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof LeafSchemaNode), (String)"Node %s is not a leaf", (Object)schema.getPath());
        return (LeafSchemaNode)schema;
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.schemaStack.push((DocumentedNode.WithStatus)this.leafNode(name));
    }

    public LeafListSchemaNode startLeafSet(YangInstanceIdentifier.NodeIdentifier name) {
        SchemaNode schema = this.getSchema((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof LeafListSchemaNode), (String)"Node %s is not a leaf-list", (Object)schema.getPath());
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
        return (LeafListSchemaNode)schema;
    }

    public LeafListSchemaNode leafSetEntryNode(QName qname) {
        Object parent = this.getParent();
        if (parent instanceof LeafListSchemaNode) {
            return (LeafListSchemaNode)parent;
        }
        SchemaNode child = SchemaUtils.findDataChildSchemaByQName((SchemaNode)parent, qname);
        Preconditions.checkArgument((boolean)(child instanceof LeafListSchemaNode), (String)"Node %s is neither a leaf-list nor currently in a leaf-list", (Object)child.getPath());
        return (LeafListSchemaNode)child;
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        this.schemaStack.push((DocumentedNode.WithStatus)this.leafSetEntryNode(name.getNodeType()));
    }

    public ChoiceSchemaNode startChoiceNode(YangInstanceIdentifier.NodeIdentifier name) {
        LOG.debug("Enter choice {}", (Object)name);
        SchemaNode schema = this.getSchema((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof ChoiceSchemaNode), (String)"Node %s is not a choice", (Object)schema.getPath());
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
        return (ChoiceSchemaNode)schema;
    }

    public SchemaNode startContainerNode(YangInstanceIdentifier.NodeIdentifier name) {
        LOG.debug("Enter container {}", (Object)name);
        SchemaNode schema = this.getSchema((YangInstanceIdentifier.PathArgument)name);
        boolean isAllowed = schema instanceof ContainerSchemaNode;
        Preconditions.checkArgument((boolean)(isAllowed |= schema instanceof NotificationDefinition), (String)"Node %s is not a container nor a notification", (Object)schema.getPath());
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
        return schema;
    }

    public SchemaNode startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name) {
        LOG.debug("Enter yang modeled anyXml {}", (Object)name);
        SchemaNode schema = this.getSchema((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof YangModeledAnyXmlSchemaNode), (String)"Node %s is not an yang modeled anyXml.", (Object)schema.getPath());
        this.schemaStack.push((DocumentedNode.WithStatus)((YangModeledAnyXmlSchemaNode)schema).getSchemaOfAnyXmlData());
        return schema;
    }

    public AugmentationSchemaNode startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        LOG.debug("Enter augmentation {}", (Object)identifier);
        Object parent = this.getParent();
        Preconditions.checkArgument((boolean)(parent instanceof AugmentationTarget), (String)"Augmentation not allowed under %s", (Object)parent);
        if (parent instanceof ChoiceSchemaNode) {
            QName name = (QName)Iterables.get((Iterable)identifier.getPossibleChildNames(), (int)0);
            parent = SchemaTracker.findCaseByChild((ChoiceSchemaNode)parent, name);
        }
        Preconditions.checkArgument((boolean)(parent instanceof DataNodeContainer), (String)"Augmentation allowed only in DataNodeContainer", (Object)parent);
        AugmentationSchemaNode schema = SchemaUtils.findSchemaForAugment((AugmentationTarget)parent, (Set<QName>)identifier.getPossibleChildNames());
        AugmentationSchemaNode resolvedSchema = EffectiveAugmentationSchema.create((AugmentationSchemaNode)schema, (DataNodeContainer)((DataNodeContainer)parent));
        this.schemaStack.push((DocumentedNode.WithStatus)resolvedSchema);
        return resolvedSchema;
    }

    public AnyXmlSchemaNode anyxmlNode(YangInstanceIdentifier.NodeIdentifier name) {
        SchemaNode schema = this.getSchema((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof AnyXmlSchemaNode), (String)"Node %s is not anyxml", (Object)schema.getPath());
        return (AnyXmlSchemaNode)schema;
    }

    public void startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.schemaStack.push((DocumentedNode.WithStatus)this.anyxmlNode(name));
    }

    public AnyDataSchemaNode anydataNode(YangInstanceIdentifier.NodeIdentifier name) {
        SchemaNode schema = this.getSchema((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof AnyDataSchemaNode), (String)"Node %s is not anydata", (Object)schema.getPath());
        return (AnyDataSchemaNode)schema;
    }

    public void startAnydataNode(YangInstanceIdentifier.NodeIdentifier name) {
        this.schemaStack.push((DocumentedNode.WithStatus)this.anydataNode(name));
    }

    public Object endNode() {
        return this.schemaStack.pop();
    }
}

