/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.Uint8Codec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;

final class Uint8StringCodec
extends AbstractIntegerStringCodec<Short, Uint8TypeDefinition>
implements Uint8Codec<String> {
    Uint8StringCodec(Optional<Uint8TypeDefinition> typeDef) {
        super(typeDef, Uint8StringCodec.extractRange(typeDef.orElse(null)), Short.class);
    }

    @Override
    public String serialize(Short data) {
        return Objects.toString(data, "");
    }

    @Override
    Short deserialize(String stringRepresentation, int base) {
        return Short.valueOf(stringRepresentation, base);
    }
}

