/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.rfc7952.data.util.ImmutableMetadataNormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNormalizationException;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizableAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeMetadataResult;
import org.opendaylight.yangtools.yang.data.util.ImmutableNormalizedAnydata;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Beta
@NonNullByDefault
public abstract class AbstractNormalizableAnydata
implements NormalizableAnydata {
    public final ImmutableNormalizedAnydata normalizeTo(SchemaContext schemaContext, DataSchemaNode contextNode) throws AnydataNormalizationException {
        NormalizedNodeMetadataResult result = new NormalizedNodeMetadataResult();
        NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from(result);
        try {
            this.writeTo(streamWriter, schemaContext, contextNode);
        }
        catch (IOException e) {
            throw new AnydataNormalizationException("Failed to normalize anydata", (Throwable)e);
        }
        return ImmutableMetadataNormalizedAnydata.ofOptional((SchemaContext)schemaContext, (DataSchemaNode)contextNode, result.getResult(), result.getMetadata());
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);

    protected abstract void writeTo(NormalizedNodeStreamWriter var1, SchemaContext var2, DataSchemaNode var3) throws IOException;
}

