/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.annotations.Beta;
import com.google.common.collect.ClassToInstanceMap;
import java.io.IOException;
import org.opendaylight.yangtools.concepts.ObjectExtensions;
import org.opendaylight.yangtools.rcf8528.data.util.ImmutableMountPointNode;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.AnydataExtension;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriterExtension;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;

@Beta
public abstract class ImmutableMountPointNormalizedNodeStreamWriter
extends ImmutableNormalizedNodeStreamWriter
implements MountPointStreamWriter {
    private static final ObjectExtensions.Factory<ImmutableMountPointNormalizedNodeStreamWriter, ?, NormalizedNodeStreamWriterExtension> EXTENSIONS_FACTORY = ObjectExtensions.factory(ImmutableMountPointNormalizedNodeStreamWriter.class, (Class[])new Class[]{AnydataExtension.class, MountPointStreamWriter.class});

    protected ImmutableMountPointNormalizedNodeStreamWriter(NormalizedNodeResult result) {
        super(result);
    }

    @Override
    public final ClassToInstanceMap<NormalizedNodeStreamWriterExtension> getExtensions() {
        return EXTENSIONS_FACTORY.newInstance((Object)this);
    }

    public final NormalizedNodeStreamWriter startMountPoint(final MountPointIdentifier mountId, final MountPointContext mountCtx) {
        final NormalizedNodeResult mountResult = new NormalizedNodeResult();
        final NormalizedNodeStreamWriter mountDelegate = ImmutableNormalizedNodeStreamWriter.from(mountResult);
        return new ForwardingNormalizedNodeStreamWriter(){

            protected NormalizedNodeStreamWriter delegate() {
                return mountDelegate;
            }

            public void close() throws IOException {
                super.close();
                NormalizedNode<?, ?> data = mountResult.getResult();
                if (!(data instanceof ContainerNode)) {
                    throw new IOException("Unhandled mount data " + data);
                }
                ImmutableMountPointNormalizedNodeStreamWriter.this.writeChild((NormalizedNode<?, ?>)ImmutableMountPointNode.of((MountPointIdentifier)mountId, (MountPointContext)mountCtx, (ContainerNode)((ContainerNode)data)));
            }
        };
    }
}

