/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableChoiceNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUnkeyedListNodeBuilder;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class ImmutableNodes {
    private static final YangInstanceIdentifier.NodeIdentifier SCHEMACONTEXT_NAME = YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME);

    private ImmutableNodes() {
        throw new UnsupportedOperationException("Utilities class should not be instantiated");
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, MapNode> mapNodeBuilder() {
        return ImmutableMapNodeBuilder.create();
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, MapNode> mapNodeBuilder(QName name) {
        return ImmutableNodes.mapNodeBuilder(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, MapNode> mapNodeBuilder(YangInstanceIdentifier.NodeIdentifier name) {
        return ImmutableMapNodeBuilder.create().withNodeIdentifier(name);
    }

    public static @NonNull MapNode mapNode(QName name) {
        return ImmutableNodes.mapNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull MapNode mapNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (MapNode)ImmutableNodes.mapNodeBuilder(name).build();
    }

    public static @NonNull OrderedMapNode orderedMapNode(QName name) {
        return ImmutableNodes.orderedMapNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull OrderedMapNode orderedMapNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (OrderedMapNode)ImmutableOrderedMapNodeBuilder.create().withNodeIdentifier(name).build();
    }

    public static <T> @NonNull LeafNode<T> leafNode(YangInstanceIdentifier.NodeIdentifier name, T value) {
        return ImmutableLeafNodeBuilder.create().withNodeIdentifier(name).withValue(value).build();
    }

    public static <T> @NonNull LeafNode<T> leafNode(QName name, T value) {
        return ImmutableNodes.leafNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name), value);
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder(QName nodeName, QName keyName, Object keyValue) {
        return ImmutableMapEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)nodeName, (QName)keyName, (Object)keyValue)).withChild((DataContainerChild<?, ?>)ImmutableNodes.leafNode(keyName, keyValue));
    }

    public static @NonNull DataContainerNodeBuilder<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntryBuilder() {
        return ImmutableMapEntryNodeBuilder.create();
    }

    public static @NonNull MapEntryNode mapEntry(QName nodeName, QName keyName, Object keyValue) {
        return (MapEntryNode)ImmutableNodes.mapEntryBuilder(nodeName, keyName, keyValue).build();
    }

    public static @NonNull ContainerNode containerNode(QName name) {
        return ImmutableNodes.containerNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull ContainerNode containerNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).build();
    }

    public static @NonNull ChoiceNode choiceNode(QName name) {
        return ImmutableNodes.choiceNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull ChoiceNode choiceNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (ChoiceNode)ImmutableChoiceNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)name).build();
    }

    public static @NonNull UnkeyedListNode listNode(QName name) {
        return ImmutableNodes.listNode(YangInstanceIdentifier.NodeIdentifier.create((QName)name));
    }

    public static @NonNull UnkeyedListNode listNode(YangInstanceIdentifier.NodeIdentifier name) {
        return (UnkeyedListNode)ImmutableUnkeyedListNodeBuilder.create().withNodeIdentifier(name).build();
    }

    public static @NonNull NormalizedNode<?, ?> fromInstanceId(SchemaContext ctx, YangInstanceIdentifier id) {
        return ImmutableNodes.fromInstanceId(ctx, id, Optional.empty());
    }

    public static @NonNull NormalizedNode<?, ?> fromInstanceId(SchemaContext ctx, YangInstanceIdentifier id, NormalizedNode<?, ?> deepestElement) {
        return ImmutableNodes.fromInstanceId(ctx, id, Optional.of(deepestElement));
    }

    public static @NonNull NormalizedNode<?, ?> fromInstanceId(SchemaContext ctx, YangInstanceIdentifier id, Optional<NormalizedNode<?, ?>> deepestElement) {
        InstanceIdToNodes<?> instanceIdToNodes;
        YangInstanceIdentifier.NodeIdentifier topLevelElement;
        Iterator<YangInstanceIdentifier.PathArgument> it = id.getPathArguments().iterator();
        if (it.hasNext()) {
            topLevelElement = (YangInstanceIdentifier.PathArgument)it.next();
            DataSchemaNode dataChildByName = ctx.getDataChildByName(topLevelElement.getNodeType());
            Preconditions.checkNotNull((Object)dataChildByName, (String)"Cannot find %s node in schema context. Instance identifier has to start from root", (Object)topLevelElement);
            instanceIdToNodes = InstanceIdToNodes.fromSchemaAndQNameChecked((DataNodeContainer)ctx, topLevelElement.getNodeType());
        } else {
            topLevelElement = SCHEMACONTEXT_NAME;
            instanceIdToNodes = InstanceIdToNodes.fromDataSchemaNode((DataSchemaNode)ctx);
        }
        return instanceIdToNodes.create((YangInstanceIdentifier.PathArgument)topLevelElement, it, deepestElement);
    }
}

