/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class SchemaUtils {
    private SchemaUtils() {
        throw new UnsupportedOperationException();
    }

    public static Optional<DataSchemaNode> findFirstSchema(QName qname, Iterable<DataSchemaNode> dataSchemaNode) {
        DataSchemaNode schema = null;
        if (dataSchemaNode != null && qname != null) {
            for (DataSchemaNode dsn : dataSchemaNode) {
                if (qname.isEqualWithoutRevision(dsn.getQName())) {
                    if (schema != null && Revision.compare((Optional)schema.getQName().getRevision(), (Optional)dsn.getQName().getRevision()) >= 0) continue;
                    schema = dsn;
                    continue;
                }
                if (!(dsn instanceof ChoiceSchemaNode)) continue;
                for (CaseSchemaNode choiceCase : ((ChoiceSchemaNode)dsn).getCases().values()) {
                    Optional dataChildByName = choiceCase.findDataChildByName(qname);
                    if (dataChildByName.isPresent()) {
                        return dataChildByName;
                    }
                    Optional<DataSchemaNode> foundDsn = SchemaUtils.findFirstSchema(qname, choiceCase.getChildNodes());
                    if (!foundDsn.isPresent()) continue;
                    return foundDsn;
                }
            }
        }
        return Optional.ofNullable(schema);
    }

    public static DataSchemaNode findSchemaForChild(DataNodeContainer schema, QName qname) {
        Optional dataChildByName = schema.findDataChildByName(qname);
        return dataChildByName.isPresent() ? (DataSchemaNode)dataChildByName.get() : SchemaUtils.findSchemaForChild(schema, qname, schema.getChildNodes());
    }

    public static @Nullable DataSchemaNode findSchemaForChild(DataNodeContainer schema, QName qname, boolean strictMode) {
        if (strictMode) {
            return SchemaUtils.findSchemaForChild(schema, qname);
        }
        Optional<DataSchemaNode> childSchemaOptional = SchemaUtils.findFirstSchema(qname, schema.getChildNodes());
        if (!childSchemaOptional.isPresent()) {
            return null;
        }
        return childSchemaOptional.get();
    }

    public static DataSchemaNode findSchemaForChild(DataNodeContainer schema, QName qname, Iterable<DataSchemaNode> childNodes) {
        Optional<DataSchemaNode> childSchema = SchemaUtils.findFirstSchema(qname, childNodes);
        Preconditions.checkState((boolean)childSchema.isPresent(), (String)"Unknown child(ren) node(s) detected, identified by: %s, in: %s", (Object)qname, (Object)schema);
        return childSchema.get();
    }

    public static DataSchemaNode findSchemaForChild(ChoiceSchemaNode schema, QName childPartialQName) {
        for (CaseSchemaNode choiceCaseNode : schema.getCases().values()) {
            Optional<DataSchemaNode> childSchema = SchemaUtils.findFirstSchema(childPartialQName, choiceCaseNode.getChildNodes());
            if (!childSchema.isPresent()) continue;
            return childSchema.get();
        }
        throw new IllegalStateException(String.format("Unknown child(ren) node(s) detected, identified by: %s, in: %s", childPartialQName, schema));
    }

    public static AugmentationSchemaNode findSchemaForAugment(AugmentationTarget schema, Set<QName> qnames) {
        Optional<AugmentationSchemaNode> schemaForAugment = SchemaUtils.findAugment(schema, qnames);
        Preconditions.checkState((boolean)schemaForAugment.isPresent(), (String)"Unknown augmentation node detected, identified by: %s, in: %s", qnames, (Object)schema);
        return schemaForAugment.get();
    }

    public static AugmentationSchemaNode findSchemaForAugment(ChoiceSchemaNode schema, Set<QName> qnames) {
        for (CaseSchemaNode choiceCaseNode : schema.getCases().values()) {
            Optional<AugmentationSchemaNode> schemaForAugment = SchemaUtils.findAugment((AugmentationTarget)choiceCaseNode, qnames);
            if (!schemaForAugment.isPresent()) continue;
            return schemaForAugment.get();
        }
        throw new IllegalStateException(String.format("Unknown augmentation node detected, identified by: %s, in: %s", qnames, schema));
    }

    private static Optional<AugmentationSchemaNode> findAugment(AugmentationTarget schema, Set<QName> qnames) {
        for (AugmentationSchemaNode augment : schema.getAvailableAugmentations()) {
            ImmutableSet qNamesFromAugment = ImmutableSet.copyOf((Collection)Collections2.transform((Collection)augment.getChildNodes(), SchemaNode::getQName));
            if (!qnames.equals(qNamesFromAugment)) continue;
            return Optional.of(augment);
        }
        return Optional.empty();
    }

    public static Map<QName, ChoiceSchemaNode> mapChildElementsFromChoices(DataNodeContainer schema) {
        return SchemaUtils.mapChildElementsFromChoices(schema, schema.getChildNodes());
    }

    private static Map<QName, ChoiceSchemaNode> mapChildElementsFromChoices(DataNodeContainer schema, Iterable<DataSchemaNode> childNodes) {
        LinkedHashMap<QName, ChoiceSchemaNode> mappedChoices = new LinkedHashMap<QName, ChoiceSchemaNode>();
        for (DataSchemaNode childSchema : childNodes) {
            if (!(childSchema instanceof ChoiceSchemaNode) || SchemaUtils.isFromAugment(schema, childSchema)) continue;
            for (CaseSchemaNode choiceCaseNode : ((ChoiceSchemaNode)childSchema).getCases().values()) {
                for (QName qname : SchemaUtils.getChildNodesRecursive((DataNodeContainer)choiceCaseNode)) {
                    mappedChoices.put(qname, (ChoiceSchemaNode)childSchema);
                }
            }
        }
        return mappedChoices;
    }

    private static boolean isFromAugment(DataNodeContainer schema, DataSchemaNode childSchema) {
        if (!(schema instanceof AugmentationTarget)) {
            return false;
        }
        for (AugmentationSchemaNode augmentation : ((AugmentationTarget)schema).getAvailableAugmentations()) {
            if (!augmentation.findDataChildByName(childSchema.getQName()).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static Map<QName, AugmentationSchemaNode> mapChildElementsFromAugments(AugmentationTarget schema) {
        LinkedHashMap<QName, AugmentationSchemaNode> childNodesToAugmentation = new LinkedHashMap<QName, AugmentationSchemaNode>();
        HashMap<QName, AugmentationSchemaNode> augments = new HashMap<QName, AugmentationSchemaNode>();
        for (AugmentationSchemaNode augmentationSchema : schema.getAvailableAugmentations()) {
            for (Object dataSchemaNode : augmentationSchema.getChildNodes()) {
                augments.put(dataSchemaNode.getQName(), augmentationSchema);
            }
        }
        if (schema instanceof DataNodeContainer) {
            for (DataSchemaNode child : ((DataNodeContainer)schema).getChildNodes()) {
                if (!augments.containsKey(child.getQName())) continue;
                AugmentationSchemaNode mostTopAugmentation = (AugmentationSchemaNode)augments.get(child.getQName());
                if (child instanceof AugmentationSchemaNode || child instanceof CaseSchemaNode) {
                    for (QName qname : SchemaUtils.getChildNodesRecursive((DataNodeContainer)child)) {
                        childNodesToAugmentation.put(qname, mostTopAugmentation);
                    }
                    continue;
                }
                if (child instanceof ChoiceSchemaNode) {
                    for (CaseSchemaNode choiceCaseNode : ((ChoiceSchemaNode)child).getCases().values()) {
                        for (QName qname : SchemaUtils.getChildNodesRecursive((DataNodeContainer)choiceCaseNode)) {
                            childNodesToAugmentation.put(qname, mostTopAugmentation);
                        }
                    }
                    continue;
                }
                childNodesToAugmentation.put(child.getQName(), mostTopAugmentation);
            }
        }
        if (schema instanceof ChoiceSchemaNode) {
            for (CaseSchemaNode choiceCaseNode : ((ChoiceSchemaNode)schema).getCases().values()) {
                if (!augments.containsKey(choiceCaseNode.getQName())) continue;
                for (QName qname : SchemaUtils.getChildNodesRecursive((DataNodeContainer)choiceCaseNode)) {
                    childNodesToAugmentation.put(qname, (AugmentationSchemaNode)augments.get(choiceCaseNode.getQName()));
                }
            }
        }
        return childNodesToAugmentation;
    }

    public static Set<QName> getChildNodesRecursive(DataNodeContainer nodeContainer) {
        HashSet<QName> allChildNodes = new HashSet<QName>();
        for (DataSchemaNode childSchema : nodeContainer.getChildNodes()) {
            if (childSchema instanceof ChoiceSchemaNode) {
                for (CaseSchemaNode choiceCaseNode : ((ChoiceSchemaNode)childSchema).getCases().values()) {
                    allChildNodes.addAll(SchemaUtils.getChildNodesRecursive((DataNodeContainer)choiceCaseNode));
                }
                continue;
            }
            if (childSchema instanceof AugmentationSchemaNode || childSchema instanceof CaseSchemaNode) {
                allChildNodes.addAll(SchemaUtils.getChildNodesRecursive((DataNodeContainer)childSchema));
                continue;
            }
            allChildNodes.add(childSchema.getQName());
        }
        return allChildNodes;
    }

    public static Set<DataSchemaNode> getRealSchemasForAugment(AugmentationTarget targetSchema, AugmentationSchemaNode augmentSchema) {
        if (!targetSchema.getAvailableAugmentations().contains(augmentSchema)) {
            return ImmutableSet.of();
        }
        if (targetSchema instanceof DataNodeContainer) {
            return SchemaUtils.getRealSchemasForAugment((DataNodeContainer)targetSchema, augmentSchema);
        }
        HashSet<DataSchemaNode> realChildNodes = new HashSet<DataSchemaNode>();
        if (targetSchema instanceof ChoiceSchemaNode) {
            for (DataSchemaNode dataSchemaNode : augmentSchema.getChildNodes()) {
                for (CaseSchemaNode choiceCaseNode : ((ChoiceSchemaNode)targetSchema).getCases().values()) {
                    if (!SchemaUtils.getChildNodesRecursive((DataNodeContainer)choiceCaseNode).contains(dataSchemaNode.getQName())) continue;
                    realChildNodes.add(choiceCaseNode.getDataChildByName(dataSchemaNode.getQName()));
                }
            }
        }
        return realChildNodes;
    }

    public static Set<DataSchemaNode> getRealSchemasForAugment(DataNodeContainer targetSchema, AugmentationSchemaNode augmentSchema) {
        HashSet<DataSchemaNode> realChildNodes = new HashSet<DataSchemaNode>();
        for (DataSchemaNode dataSchemaNode : augmentSchema.getChildNodes()) {
            DataSchemaNode realChild = targetSchema.getDataChildByName(dataSchemaNode.getQName());
            realChildNodes.add(realChild);
        }
        return realChildNodes;
    }

    public static Optional<CaseSchemaNode> detectCase(ChoiceSchemaNode schema, DataContainerChild<?, ?> child) {
        for (CaseSchemaNode choiceCaseNode : schema.getCases().values()) {
            if (child instanceof AugmentationNode && SchemaUtils.belongsToCaseAugment(choiceCaseNode, (YangInstanceIdentifier.AugmentationIdentifier)child.getIdentifier())) {
                return Optional.of(choiceCaseNode);
            }
            if (!choiceCaseNode.findDataChildByName(child.getNodeType()).isPresent()) continue;
            return Optional.of(choiceCaseNode);
        }
        return Optional.empty();
    }

    public static boolean belongsToCaseAugment(CaseSchemaNode caseNode, YangInstanceIdentifier.AugmentationIdentifier childToProcess) {
        for (AugmentationSchemaNode augmentationSchema : caseNode.getAvailableAugmentations()) {
            HashSet<QName> currentAugmentChildNodes = new HashSet<QName>();
            for (DataSchemaNode dataSchemaNode : augmentationSchema.getChildNodes()) {
                currentAugmentChildNodes.add(dataSchemaNode.getQName());
            }
            if (!childToProcess.getPossibleChildNames().equals(currentAugmentChildNodes)) continue;
            return true;
        }
        return false;
    }

    public static AugmentationSchemaNode findCorrespondingAugment(DataSchemaNode parent, DataSchemaNode child) {
        if (!(parent instanceof AugmentationTarget) || parent instanceof ChoiceSchemaNode) {
            return null;
        }
        for (AugmentationSchemaNode augmentation : ((AugmentationTarget)parent).getAvailableAugmentations()) {
            Optional childInAugmentation = augmentation.findDataChildByName(child.getQName());
            if (!childInAugmentation.isPresent()) continue;
            return augmentation;
        }
        return null;
    }

    public static SchemaNode findDataParentSchemaOnPath(SchemaContext schemaContext, SchemaPath path) {
        SchemaNode current = (SchemaNode)Objects.requireNonNull(schemaContext);
        for (QName qname : path.getPathFromRoot()) {
            current = SchemaUtils.findDataChildSchemaByQName(current, qname);
        }
        return current;
    }

    public static @Nullable SchemaNode findDataChildSchemaByQName(SchemaNode node, QName qname) {
        if (node instanceof DataNodeContainer) {
            DataSchemaNode child = ((DataNodeContainer)node).getDataChildByName(qname);
            if (child == null && node instanceof SchemaContext) {
                child = SchemaUtils.tryFind(((SchemaContext)node).getOperations(), qname).orElse(null);
            }
            if (child == null && node instanceof NotificationNodeContainer) {
                child = SchemaUtils.tryFind(((NotificationNodeContainer)node).getNotifications(), qname).orElse(null);
            }
            if (child == null && node instanceof ActionNodeContainer) {
                child = SchemaUtils.tryFind(((ActionNodeContainer)node).getActions(), qname).orElse(null);
            }
            return child;
        }
        if (node instanceof ChoiceSchemaNode) {
            return (SchemaNode)((ChoiceSchemaNode)node).getCases().get(qname);
        }
        if (node instanceof OperationDefinition) {
            switch (qname.getLocalName()) {
                case "input": {
                    return ((OperationDefinition)node).getInput();
                }
                case "output": {
                    return ((OperationDefinition)node).getOutput();
                }
            }
            return null;
        }
        throw new IllegalArgumentException(String.format("Schema node %s does not allow children.", node));
    }

    public static Collection<SchemaNode> findParentSchemaNodesOnPath(SchemaContext schemaContext, SchemaPath path) {
        ArrayList<SchemaNode> currentNodes = new ArrayList<SchemaNode>();
        ArrayList<SchemaNode> childNodes = new ArrayList<SchemaNode>();
        currentNodes.add((SchemaNode)Objects.requireNonNull(schemaContext));
        for (QName qname : path.getPathFromRoot()) {
            for (SchemaNode current : currentNodes) {
                childNodes.addAll(SchemaUtils.findChildSchemaNodesByQName(current, qname));
            }
            currentNodes.clear();
            currentNodes.addAll(childNodes);
            childNodes.clear();
        }
        return currentNodes;
    }

    public static Collection<SchemaNode> findChildSchemaNodesByQName(SchemaNode node, QName qname) {
        ArrayList<SchemaNode> childNodes = new ArrayList<SchemaNode>();
        SchemaNode dataNode = SchemaUtils.findDataChildSchemaByQName(node, qname);
        if (dataNode != null) {
            childNodes.add(dataNode);
        }
        if (node instanceof DataNodeContainer) {
            SchemaUtils.tryFind(((DataNodeContainer)node).getGroupings(), qname).ifPresent(childNodes::add);
        }
        return childNodes.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(childNodes);
    }

    private static <T extends SchemaNode> Optional<T> tryFind(Collection<T> nodes, QName qname) {
        return nodes.stream().filter(node -> qname.equals((Object)node.getQName())).findFirst();
    }
}

