/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractCursorAware;

abstract class AbstractCursor<T extends AbstractCursorAware>
implements DataTreeSnapshotCursor {
    private static final AtomicIntegerFieldUpdater<AbstractCursor> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractCursor.class, "closed");
    private final YangInstanceIdentifier rootPath;
    private final T parent;
    private volatile int closed;

    AbstractCursor(T parent, YangInstanceIdentifier rootPath) {
        this.rootPath = Objects.requireNonNull(rootPath);
        this.parent = (AbstractCursorAware)Objects.requireNonNull(parent);
    }

    final T getParent() {
        return this.parent;
    }

    final YangInstanceIdentifier getRootPath() {
        return this.rootPath;
    }

    final void ensureNotClosed() {
        Preconditions.checkState((this.closed == 0 ? 1 : 0) != 0, (Object)"Modification cursor has been closed");
    }

    public final void enter(YangInstanceIdentifier.PathArgument ... path) {
        this.enter(Arrays.asList(path));
    }

    public final void exit() {
        this.exit(1);
    }

    public final void close() {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            ((AbstractCursorAware)this.parent).closeCursor(this);
        }
    }
}

