/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNodeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;

final class ModifiedNode
extends NodeModification
implements StoreTreeNode<ModifiedNode> {
    static final Predicate<ModifiedNode> IS_TERMINAL_PREDICATE = input -> {
        Objects.requireNonNull(input);
        switch (input.getOperation()) {
            case DELETE: 
            case MERGE: 
            case WRITE: {
                return true;
            }
            case NONE: 
            case TOUCH: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unhandled modification type " + (Object)((Object)input.getOperation()));
    };
    private final Map<YangInstanceIdentifier.PathArgument, ModifiedNode> children;
    private final Optional<TreeNode> original;
    private final YangInstanceIdentifier.PathArgument identifier;
    private LogicalOperation operation = LogicalOperation.NONE;
    private Optional<TreeNode> snapshotCache;
    private NormalizedNode<?, ?> value;
    private ModificationType modType;
    private TreeNode writtenOriginal;
    private ModificationApplyOperation validatedOp;
    private Optional<TreeNode> validatedCurrent;
    private Optional<TreeNode> validatedNode;

    private ModifiedNode(YangInstanceIdentifier.PathArgument identifier, Optional<TreeNode> original, ChildTrackingPolicy childPolicy) {
        this.identifier = identifier;
        this.original = original;
        this.children = childPolicy.createMap();
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    @Override
    LogicalOperation getOperation() {
        return this.operation;
    }

    @Override
    Optional<TreeNode> getOriginal() {
        return this.original;
    }

    @NonNull NormalizedNode<?, ?> getWrittenValue() {
        return (NormalizedNode)Verify.verifyNotNull(this.value);
    }

    public Optional<ModifiedNode> getChild(YangInstanceIdentifier.PathArgument child) {
        return Optional.ofNullable(this.children.get(child));
    }

    private Optional<TreeNode> metadataFromSnapshot(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child) {
        return this.original.isPresent() ? this.original.get().getChild(child) : Optional.empty();
    }

    private Optional<TreeNode> metadataFromData(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, Version modVersion) {
        if (this.writtenOriginal == null) {
            this.writtenOriginal = TreeNodeFactory.createTreeNode(this.value, (Version)modVersion);
        }
        return this.writtenOriginal.getChild(child);
    }

    private Optional<TreeNode> findOriginalMetadata(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, Version modVersion) {
        switch (this.operation) {
            case DELETE: {
                return Optional.empty();
            }
            case NONE: 
            case TOUCH: 
            case MERGE: {
                return this.metadataFromSnapshot(child);
            }
            case WRITE: {
                return this.metadataFromData(child, modVersion);
            }
        }
        throw new IllegalStateException("Unhandled node operation " + (Object)((Object)this.operation));
    }

    ModifiedNode modifyChild(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, @NonNull ModificationApplyOperation childOper, @NonNull Version modVersion) {
        Optional childData;
        ModifiedNode potential;
        this.clearSnapshot();
        if (this.operation == LogicalOperation.NONE) {
            this.updateOperationType(LogicalOperation.TOUCH);
        }
        if ((potential = this.children.get(child)) != null) {
            return potential;
        }
        Optional<TreeNode> currentMetadata = this.findOriginalMetadata(child, modVersion);
        ModifiedNode newlyCreated = new ModifiedNode(child, currentMetadata, childOper.getChildPolicy());
        if (this.operation == LogicalOperation.MERGE && this.value != null && (childData = ((NormalizedNodeContainer)this.value).getChild(child)).isPresent()) {
            childOper.mergeIntoModifiedNode(newlyCreated, (NormalizedNode)childData.get(), modVersion);
        }
        this.children.put(child, newlyCreated);
        return newlyCreated;
    }

    Collection<ModifiedNode> getChildren() {
        return this.children.values();
    }

    void delete() {
        LogicalOperation newType;
        switch (this.operation) {
            case DELETE: 
            case NONE: {
                newType = LogicalOperation.DELETE;
                break;
            }
            case MERGE: {
                newType = LogicalOperation.DELETE;
                break;
            }
            case TOUCH: 
            case WRITE: {
                newType = this.original.isPresent() ? LogicalOperation.DELETE : LogicalOperation.NONE;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled deletion of node with " + (Object)((Object)this.operation));
            }
        }
        this.clearSnapshot();
        this.children.clear();
        this.value = null;
        this.updateOperationType(newType);
    }

    void write(NormalizedNode<?, ?> newValue) {
        this.updateValue(LogicalOperation.WRITE, newValue);
        this.children.clear();
    }

    void seal(ModificationApplyOperation schema, Version version) {
        this.clearSnapshot();
        this.writtenOriginal = null;
        switch (this.operation) {
            case TOUCH: {
                if (!this.children.isEmpty()) break;
                this.updateOperationType(LogicalOperation.NONE);
                break;
            }
            case WRITE: {
                if (!this.children.isEmpty()) {
                    this.value = schema.apply(this, this.getOriginal(), version).map(TreeNode::getData).orElse(null);
                    this.children.clear();
                }
                if (this.value == null) {
                    this.updateOperationType(LogicalOperation.DELETE);
                    break;
                }
                schema.fullVerifyStructure(this.value);
                break;
            }
        }
    }

    private void clearSnapshot() {
        this.snapshotCache = null;
    }

    Optional<TreeNode> getSnapshot() {
        return this.snapshotCache;
    }

    Optional<TreeNode> setSnapshot(Optional<TreeNode> snapshot) {
        this.snapshotCache = Objects.requireNonNull(snapshot);
        return snapshot;
    }

    void updateOperationType(LogicalOperation type) {
        this.operation = type;
        this.modType = null;
        this.writtenOriginal = null;
        this.clearSnapshot();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues().add("identifier", (Object)this.identifier).add("operation", (Object)this.operation).add("modificationType", (Object)this.modType);
        if (!this.children.isEmpty()) {
            helper.add("childModification", this.children);
        }
        return helper.toString();
    }

    void resolveModificationType(@NonNull ModificationType type) {
        this.modType = type;
    }

    void updateValue(LogicalOperation type, NormalizedNode<?, ?> newValue) {
        this.value = Objects.requireNonNull(newValue);
        this.updateOperationType(type);
    }

    ModificationType getModificationType() {
        return this.modType;
    }

    public static ModifiedNode createUnmodified(TreeNode metadataTree, ChildTrackingPolicy childPolicy) {
        return new ModifiedNode((YangInstanceIdentifier.PathArgument)metadataTree.getIdentifier(), Optional.of(metadataTree), childPolicy);
    }

    void setValidatedNode(ModificationApplyOperation op, Optional<TreeNode> current, Optional<TreeNode> node) {
        this.validatedOp = Objects.requireNonNull(op);
        this.validatedCurrent = Objects.requireNonNull(current);
        this.validatedNode = Objects.requireNonNull(node);
    }

    Optional<TreeNode> getValidatedNode(ModificationApplyOperation op, Optional<TreeNode> current) {
        return op.equals(this.validatedOp) && current.equals(this.validatedCurrent) ? this.validatedNode : null;
    }
}

