/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LogicalOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;

final class NoopDataTreeCandidate
extends AbstractDataTreeCandidate {
    private static final DataTreeCandidateNode ROOT = new DataTreeCandidateNode(){

        public ModificationType getModificationType() {
            return ModificationType.UNMODIFIED;
        }

        public Collection<DataTreeCandidateNode> getChildNodes() {
            return ImmutableList.of();
        }

        public YangInstanceIdentifier.PathArgument getIdentifier() {
            throw new IllegalStateException("Attempted to read identifier of the no-operation change");
        }

        public Optional<NormalizedNode<?, ?>> getDataAfter() {
            return Optional.empty();
        }

        public Optional<NormalizedNode<?, ?>> getDataBefore() {
            return Optional.empty();
        }

        public Optional<DataTreeCandidateNode> getModifiedChild(YangInstanceIdentifier.PathArgument identifier) {
            return Optional.empty();
        }
    };
    private final @NonNull TreeNode afterRoot;

    protected NoopDataTreeCandidate(YangInstanceIdentifier rootPath, ModifiedNode modificationRoot, TreeNode afterRoot) {
        super(rootPath);
        Preconditions.checkArgument((modificationRoot.getOperation() == LogicalOperation.NONE ? 1 : 0) != 0);
        this.afterRoot = Objects.requireNonNull(afterRoot);
    }

    public DataTreeCandidateNode getRootNode() {
        return ROOT;
    }

    @Override
    protected TreeNode getTipRoot() {
        return this.afterRoot;
    }
}

