/*
 * Copyright (c) 2019 PANTHEON.tech, s.r.o. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import static java.util.Objects.requireNonNull;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier.PathArgument;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;

@SuppressWarnings("rawtypes")
final class NormalizedNodeResultBuilder implements NormalizedNodeContainerBuilder {
    private final @NonNull NormalizedNodeResult result;

    NormalizedNodeResultBuilder() {
        this.result = new NormalizedNodeResult();
    }

    NormalizedNodeResultBuilder(final NormalizedNodeResult result) {
        this.result = requireNonNull(result);
    }

    @NonNull NormalizedNodeResult result() {
        return result;
    }

    @Override
    public NormalizedNodeBuilder withValue(final Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NormalizedNodeContainerBuilder withValue(final Collection value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NormalizedNode build() {
        throw new IllegalStateException("Can not close NormalizedNodeResult");
    }

    @Override
    public NormalizedNodeContainerBuilder withNodeIdentifier(final PathArgument nodeIdentifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NormalizedNodeContainerBuilder addChild(final NormalizedNode child) {
        result.setResult(child);
        return this;
    }

    @Override
    public NormalizedNodeContainerBuilder removeChild(final PathArgument key) {
        throw new UnsupportedOperationException();
    }
}