/*
 * Copyright (c) 2014 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

final class NotUpgradableRootApplyStrategy extends RootApplyStrategy {
    private final ModificationApplyOperation delegate;

    NotUpgradableRootApplyStrategy(final ModificationApplyOperation delegate) {
        this.delegate = delegate;
    }

    @Override
    protected ModificationApplyOperation delegate() {
        return delegate;
    }

    @Override
    void upgradeIfPossible() {
        // Intentional noop
    }

    @Override
    RootApplyStrategy snapshot() {
        return this;
    }
}
