/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.codec.Uint32Codec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;

final class Uint32StringCodec
extends AbstractIntegerStringCodec<Long, Uint32TypeDefinition>
implements Uint32Codec<String> {
    Uint32StringCodec(Optional<Uint32TypeDefinition> typeDef) {
        super(typeDef, Uint32StringCodec.extractRange(typeDef.orElse(null)), Long.class);
    }

    @Override
    Long deserialize(String stringRepresentation, int base) {
        return Long.valueOf(stringRepresentation, base);
    }

    @Override
    public String serialize(Long data) {
        return Objects.toString(data, "");
    }
}

