/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.leafref;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.impl.leafref.LeafRefContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class LeafRefContextUtils {
    private LeafRefContextUtils() {
    }

    public static LeafRefContext getLeafRefReferencingContext(SchemaNode node, LeafRefContext root) {
        SchemaPath schemaPath = node.getPath();
        return LeafRefContextUtils.getLeafRefReferencingContext(schemaPath, root);
    }

    public static LeafRefContext getLeafRefReferencingContext(SchemaPath schemaPath, LeafRefContext root) {
        Iterable pathFromRoot = schemaPath.getPathFromRoot();
        return LeafRefContextUtils.getLeafRefReferencingContext(pathFromRoot, root);
    }

    public static LeafRefContext getLeafRefReferencingContext(Iterable<QName> pathFromRoot, LeafRefContext root) {
        LeafRefContext leafRefCtx = null;
        Iterator<QName> iterator = pathFromRoot.iterator();
        while (iterator.hasNext() && root != null) {
            QName qname = iterator.next();
            leafRefCtx = root.getReferencingChildByName(qname);
            if (!iterator.hasNext()) continue;
            root = leafRefCtx;
        }
        return leafRefCtx;
    }

    public static LeafRefContext getLeafRefReferencedByContext(SchemaNode node, LeafRefContext root) {
        SchemaPath schemaPath = node.getPath();
        return LeafRefContextUtils.getLeafRefReferencedByContext(schemaPath, root);
    }

    public static LeafRefContext getLeafRefReferencedByContext(SchemaPath schemaPath, LeafRefContext root) {
        Iterable pathFromRoot = schemaPath.getPathFromRoot();
        return LeafRefContextUtils.getLeafRefReferencedByContext(pathFromRoot, root);
    }

    public static LeafRefContext getLeafRefReferencedByContext(Iterable<QName> pathFromRoot, LeafRefContext root) {
        LeafRefContext leafRefCtx = null;
        Iterator<QName> iterator = pathFromRoot.iterator();
        while (iterator.hasNext() && root != null) {
            QName qname = iterator.next();
            leafRefCtx = root.getReferencedChildByName(qname);
            if (!iterator.hasNext()) continue;
            root = leafRefCtx;
        }
        return leafRefCtx;
    }

    public static boolean isLeafRef(SchemaNode node, LeafRefContext root) {
        if (node == null || root == null) {
            return false;
        }
        LeafRefContext leafRefReferencingContext = LeafRefContextUtils.getLeafRefReferencingContext(node, root);
        if (leafRefReferencingContext == null) {
            return false;
        }
        return leafRefReferencingContext.isReferencing();
    }

    public static boolean hasLeafRefChild(SchemaNode node, LeafRefContext root) {
        if (node == null || root == null) {
            return false;
        }
        LeafRefContext leafRefReferencingContext = LeafRefContextUtils.getLeafRefReferencingContext(node, root);
        if (leafRefReferencingContext == null) {
            return false;
        }
        return leafRefReferencingContext.hasReferencingChild();
    }

    public static boolean isReferencedByLeafRef(SchemaNode node, LeafRefContext root) {
        if (node == null || root == null) {
            return false;
        }
        LeafRefContext leafRefReferencedByContext = LeafRefContextUtils.getLeafRefReferencedByContext(node, root);
        if (leafRefReferencedByContext == null) {
            return false;
        }
        return leafRefReferencedByContext.isReferenced();
    }

    public static boolean hasChildReferencedByLeafRef(SchemaNode node, LeafRefContext root) {
        if (node == null || root == null) {
            return false;
        }
        LeafRefContext leafRefReferencedByContext = LeafRefContextUtils.getLeafRefReferencedByContext(node, root);
        if (leafRefReferencedByContext == null) {
            return false;
        }
        return leafRefReferencedByContext.hasReferencedChild();
    }

    public static List<LeafRefContext> findAllLeafRefChilds(SchemaNode node, LeafRefContext root) {
        return LeafRefContextUtils.findAllLeafRefChilds(node.getPath(), root);
    }

    public static List<LeafRefContext> findAllLeafRefChilds(SchemaPath schemaPath, LeafRefContext root) {
        return LeafRefContextUtils.findAllLeafRefChilds(schemaPath.getPathFromRoot(), root);
    }

    public static List<LeafRefContext> findAllLeafRefChilds(Iterable<QName> pathFromRoot, LeafRefContext root) {
        LeafRefContext leafRefReferencingContext = LeafRefContextUtils.getLeafRefReferencingContext(pathFromRoot, root);
        List<LeafRefContext> allLeafRefsChilds = LeafRefContextUtils.findAllLeafRefChilds(leafRefReferencingContext);
        return allLeafRefsChilds;
    }

    public static List<LeafRefContext> findAllLeafRefChilds(LeafRefContext parent) {
        LinkedList<LeafRefContext> leafRefChilds = new LinkedList<LeafRefContext>();
        if (parent == null) {
            return leafRefChilds;
        }
        if (parent.isReferencing()) {
            leafRefChilds.add(parent);
            return leafRefChilds;
        }
        Set<Map.Entry<QName, LeafRefContext>> childs = parent.getReferencingChilds().entrySet();
        for (Map.Entry<QName, LeafRefContext> child : childs) {
            leafRefChilds.addAll(LeafRefContextUtils.findAllLeafRefChilds(child.getValue()));
        }
        return leafRefChilds;
    }

    public static List<LeafRefContext> findAllChildsReferencedByLeafRef(SchemaNode node, LeafRefContext root) {
        return LeafRefContextUtils.findAllChildsReferencedByLeafRef(node.getPath(), root);
    }

    public static List<LeafRefContext> findAllChildsReferencedByLeafRef(SchemaPath schemaPath, LeafRefContext root) {
        return LeafRefContextUtils.findAllChildsReferencedByLeafRef(schemaPath.getPathFromRoot(), root);
    }

    public static List<LeafRefContext> findAllChildsReferencedByLeafRef(Iterable<QName> pathFromRoot, LeafRefContext root) {
        LeafRefContext leafRefReferencedByContext = LeafRefContextUtils.getLeafRefReferencedByContext(pathFromRoot, root);
        List<LeafRefContext> allChildsReferencedByLeafRef = LeafRefContextUtils.findAllChildsReferencedByLeafRef(leafRefReferencedByContext);
        return allChildsReferencedByLeafRef;
    }

    public static List<LeafRefContext> findAllChildsReferencedByLeafRef(LeafRefContext parent) {
        LinkedList<LeafRefContext> childsReferencedByLeafRef = new LinkedList<LeafRefContext>();
        if (parent == null) {
            return childsReferencedByLeafRef;
        }
        if (parent.isReferenced()) {
            childsReferencedByLeafRef.add(parent);
            return childsReferencedByLeafRef;
        }
        Set<Map.Entry<QName, LeafRefContext>> childs = parent.getReferencedByChilds().entrySet();
        for (Map.Entry<QName, LeafRefContext> child : childs) {
            childsReferencedByLeafRef.addAll(LeafRefContextUtils.findAllChildsReferencedByLeafRef(child.getValue()));
        }
        return childsReferencedByLeafRef;
    }

    public static Map<QName, LeafRefContext> getAllLeafRefsReferencingThisNode(SchemaNode node, LeafRefContext root) {
        return LeafRefContextUtils.getAllLeafRefsReferencingThisNode(node.getPath(), root);
    }

    public static Map<QName, LeafRefContext> getAllLeafRefsReferencingThisNode(SchemaPath path, LeafRefContext root) {
        return LeafRefContextUtils.getAllLeafRefsReferencingThisNode(path.getPathFromRoot(), root);
    }

    public static Map<QName, LeafRefContext> getAllLeafRefsReferencingThisNode(Iterable<QName> pathFromRoot, LeafRefContext root) {
        LeafRefContext leafRefReferencedByContext = LeafRefContextUtils.getLeafRefReferencedByContext(pathFromRoot, root);
        if (leafRefReferencedByContext == null) {
            return new HashMap<QName, LeafRefContext>();
        }
        return leafRefReferencedByContext.getAllReferencedByLeafRefCtxs();
    }
}

