/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.InstanceIdToSimpleNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class InstanceIdToCompositeNodes<T extends YangInstanceIdentifier.PathArgument>
extends InstanceIdToNodes<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceIdToCompositeNodes.class);

    InstanceIdToCompositeNodes(T identifier) {
        super(identifier);
    }

    @Override
    final NormalizedNode<?, ?> create(YangInstanceIdentifier.PathArgument first, Iterator<YangInstanceIdentifier.PathArgument> others, Optional<NormalizedNode<?, ?>> lastChild) {
        QName type;
        if (!this.isMixin() && (type = ((YangInstanceIdentifier.PathArgument)this.getIdentifier()).getNodeType()) != null) {
            QName firstType = first.getNodeType();
            Preconditions.checkArgument((boolean)type.equals((Object)firstType), (String)"Node QName must be %s was %s", (Object)type, (Object)firstType);
        }
        NormalizedNodeContainerBuilder<?, ?, ?, ?> builder = this.createBuilder(first);
        if (others.hasNext()) {
            YangInstanceIdentifier.PathArgument childPath = others.next();
            InstanceIdToNodes<?> childOp = this.getChildOperation(childPath);
            builder.addChild(childOp.create(childPath, others, lastChild));
        } else if (lastChild.isPresent()) {
            builder.withValue((Collection<?>)ImmutableList.copyOf((Collection)((Collection)lastChild.get().getValue())));
        }
        return builder.build();
    }

    private InstanceIdToNodes<?> getChildOperation(YangInstanceIdentifier.PathArgument childPath) {
        InstanceIdToNodes<?> childOp;
        try {
            childOp = this.getChild(childPath);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Failed to process child node %s", childPath), e);
        }
        Preconditions.checkArgument((childOp != null ? 1 : 0) != 0, (String)"Node %s is not allowed inside %s", (Object)childPath, (Object)this.getIdentifier());
        return childOp;
    }

    abstract NormalizedNodeContainerBuilder<?, ?, ?, ?> createBuilder(YangInstanceIdentifier.PathArgument var1);

    static final class ChoiceNodeNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final ImmutableMap<YangInstanceIdentifier.PathArgument, InstanceIdToNodes<?>> byArg;

        ChoiceNodeNormalization(ChoiceSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
            ImmutableMap.Builder byArgBuilder = ImmutableMap.builder();
            for (CaseSchemaNode caze : schema.getCases().values()) {
                for (DataSchemaNode cazeChild : caze.getChildNodes()) {
                    InstanceIdToNodes<?> childOp = ChoiceNodeNormalization.fromDataSchemaNode(cazeChild);
                    byArgBuilder.put(childOp.getIdentifier(), childOp);
                }
            }
            this.byArg = byArgBuilder.build();
        }

        @Override
        InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return (InstanceIdToNodes)((Object)this.byArg.get((Object)child));
        }

        DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ChoiceNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.choiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getIdentifier());
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }

    static final class OrderedMapMixinNormalization
    extends UnorderedMapMixinNormalization {
        OrderedMapMixinNormalization(ListSchemaNode list) {
            super(list);
        }

        @Override
        CollectionNodeBuilder<MapEntryNode, OrderedMapNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.orderedMapBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier());
        }
    }

    static class UnorderedMapMixinNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final MapEntryNormalization innerNode;

        UnorderedMapMixinNormalization(ListSchemaNode list) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)list.getQName()));
            this.innerNode = new MapEntryNormalization(list);
        }

        CollectionNodeBuilder<MapEntryNode, ? extends MapNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.mapBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier());
        }

        @Override
        final InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return child.getNodeType().equals((Object)((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier()).getNodeType()) ? this.innerNode : null;
        }

        @Override
        final boolean isMixin() {
            return true;
        }
    }

    static final class AugmentationNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> {
        AugmentationNormalization(AugmentationSchemaNode augmentation, DataNodeContainer schema) {
            super(DataSchemaContextNode.augmentationIdentifierFrom((AugmentationSchemaNode)augmentation), EffectiveAugmentationSchema.create((AugmentationSchemaNode)augmentation, (DataNodeContainer)schema));
        }

        DataContainerNodeBuilder<YangInstanceIdentifier.AugmentationIdentifier, AugmentationNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getIdentifier());
        }

        @Override
        boolean isMixin() {
            return true;
        }
    }

    static class UnorderedLeafListMixinNormalization
    extends InstanceIdToCompositeNodes<YangInstanceIdentifier.NodeIdentifier> {
        private final InstanceIdToNodes<?> innerOp;

        UnorderedLeafListMixinNormalization(LeafListSchemaNode potential) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)potential.getQName()));
            this.innerOp = new InstanceIdToSimpleNodes.LeafListEntryNormalization(potential);
        }

        ListNodeBuilder<?, ?> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.leafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier());
        }

        @Override
        final InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            return child instanceof YangInstanceIdentifier.NodeWithValue ? this.innerOp : null;
        }

        @Override
        final boolean isMixin() {
            return true;
        }
    }

    static final class OrderedLeafListMixinNormalization
    extends UnorderedLeafListMixinNormalization {
        OrderedLeafListMixinNormalization(LeafListSchemaNode potential) {
            super(potential);
        }

        @Override
        ListNodeBuilder<?, ?> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.orderedLeafSetBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier());
        }
    }

    static final class ContainerTransformation
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifier, ContainerSchemaNode> {
        ContainerTransformation(ContainerSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), schema);
        }

        DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, ContainerNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getIdentifier());
        }

        @Override
        boolean isMixin() {
            return false;
        }
    }

    static final class UnkeyedListItemNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifier, ListSchemaNode> {
        UnkeyedListItemNormalization(ListSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), schema);
        }

        DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifier, UnkeyedListEntryNode> createBuilder(YangInstanceIdentifier.PathArgument compositeNode) {
            return Builders.unkeyedListEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getIdentifier());
        }

        @Override
        boolean isMixin() {
            return false;
        }
    }

    static final class MapEntryNormalization
    extends DataContainerNormalizationOperation<YangInstanceIdentifier.NodeIdentifierWithPredicates, ListSchemaNode> {
        MapEntryNormalization(ListSchemaNode schema) {
            super(YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)schema.getQName()), schema);
        }

        @Override
        boolean isMixin() {
            return false;
        }

        DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> createBuilder(YangInstanceIdentifier.PathArgument currentArg) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates arg = (YangInstanceIdentifier.NodeIdentifierWithPredicates)currentArg;
            return MapEntryNormalization.createBuilder(arg.size() < 2 ? arg : MapEntryNormalization.reorderPredicates(((ListSchemaNode)this.schema()).getKeyDefinition(), arg));
        }

        private static DataContainerNodeBuilder<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> createBuilder(YangInstanceIdentifier.NodeIdentifierWithPredicates arg) {
            NormalizedNodeContainerBuilder builder = Builders.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)arg);
            for (Map.Entry keyValue : arg.entrySet()) {
                builder.addChild(Builders.leafBuilder().withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)((QName)keyValue.getKey()))).withValue(keyValue.getValue()).build());
            }
            return builder;
        }

        private static YangInstanceIdentifier.NodeIdentifierWithPredicates reorderPredicates(List<QName> keys, YangInstanceIdentifier.NodeIdentifierWithPredicates arg) {
            if (Iterables.elementsEqual(keys, (Iterable)arg.keySet())) {
                return arg;
            }
            LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)arg.size());
            for (QName qname : keys) {
                Object value = arg.getValue(qname);
                if (value == null) continue;
                map.put(qname, value);
            }
            if (map.size() < arg.size()) {
                LOG.debug("Extra predicates in {} while expecting {}", (Object)arg, keys);
                for (Map.Entry entry : arg.entrySet()) {
                    map.putIfAbsent(entry.getKey(), entry.getValue());
                }
            }
            Map copy = ImmutableOffsetMap.orderedCopyOf((Map)map);
            Verify.verify((boolean)(copy instanceof ImmutableOffsetMap));
            return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)arg.getNodeType(), (ImmutableOffsetMap)((ImmutableOffsetMap)copy));
        }
    }

    static abstract class DataContainerNormalizationOperation<T extends YangInstanceIdentifier.PathArgument, S extends DataNodeContainer>
    extends InstanceIdToCompositeNodes<T> {
        private final Map<YangInstanceIdentifier.PathArgument, InstanceIdToNodes<?>> byArg = new ConcurrentHashMap();
        private final @NonNull S schema;

        DataContainerNormalizationOperation(T identifier, S schema) {
            super(identifier);
            this.schema = (DataNodeContainer)Objects.requireNonNull(schema);
        }

        @Override
        final InstanceIdToNodes<?> getChild(YangInstanceIdentifier.PathArgument child) {
            InstanceIdToNodes<?> existing = this.byArg.get(child);
            if (existing != null) {
                return existing;
            }
            return this.register(this.fromLocalSchema(child));
        }

        final @NonNull S schema() {
            return this.schema;
        }

        private InstanceIdToNodes<?> fromLocalSchema(YangInstanceIdentifier.PathArgument child) {
            if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                return DataContainerNormalizationOperation.fromSchemaAndQNameChecked(this.schema, (QName)((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames().iterator().next());
            }
            return DataContainerNormalizationOperation.fromSchemaAndQNameChecked(this.schema, child.getNodeType());
        }

        private InstanceIdToNodes<?> register(InstanceIdToNodes<?> potential) {
            if (potential != null) {
                this.byArg.put((YangInstanceIdentifier.PathArgument)potential.getIdentifier(), potential);
            }
            return potential;
        }
    }
}

