/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedLeafSetNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedNode;

public class ImmutableOrderedLeafSetNodeBuilder<T>
implements ListNodeBuilder<T, LeafSetEntryNode<T>> {
    private Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    protected ImmutableOrderedLeafSetNodeBuilder() {
        this.value = new LinkedHashMap<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>>();
        this.dirty = false;
    }

    protected ImmutableOrderedLeafSetNodeBuilder(ImmutableOrderedLeafSetNode<T> node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = ((ImmutableOrderedLeafSetNode)node).getChildren();
        this.dirty = true;
    }

    public static <T> @NonNull ListNodeBuilder<T, LeafSetEntryNode<T>> create() {
        return new ImmutableOrderedLeafSetNodeBuilder<T>();
    }

    public static <T> @NonNull ListNodeBuilder<T, LeafSetEntryNode<T>> create(LeafSetNode<T> node) {
        if (!(node instanceof ImmutableOrderedLeafSetNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableOrderedLeafSetNodeBuilder<T>((ImmutableOrderedLeafSetNode)node);
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedHashMap<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>>(this.value);
            this.dirty = false;
        }
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChild(LeafSetEntryNode<T> child) {
        this.checkDirty();
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    @Override
    public OrderedLeafSetNode<T> build() {
        this.dirty = true;
        return new ImmutableOrderedLeafSetNode<T>(this.nodeIdentifier, this.value);
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withValue(Collection<LeafSetEntryNode<T>> withValue) {
        this.checkDirty();
        for (LeafSetEntryNode<T> leafSetEntry : withValue) {
            this.withChild(leafSetEntry);
        }
        return this;
    }

    @Override
    public ListNodeBuilder<T, LeafSetEntryNode<T>> withChildValue(T childValue) {
        return this.withChild((LeafSetEntryNode)ImmutableLeafSetEntryNodeBuilder.create().withNodeIdentifier(new YangInstanceIdentifier.NodeWithValue(this.nodeIdentifier.getNodeType(), childValue)).withValue(childValue).build());
    }

    @Override
    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, LeafSetEntryNode<T>, LeafSetNode<T>> addChild(LeafSetEntryNode<T> child) {
        return this.withChild(child);
    }

    @Override
    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, LeafSetEntryNode<T>, LeafSetNode<T>> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableOrderedLeafSetNode<T>
    extends AbstractImmutableNormalizedNode<YangInstanceIdentifier.NodeIdentifier, Collection<LeafSetEntryNode<T>>>
    implements OrderedLeafSetNode<T> {
        private final Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> children;

        ImmutableOrderedLeafSetNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> children) {
            super(nodeIdentifier);
            this.children = children;
        }

        public Optional<LeafSetEntryNode<T>> getChild(YangInstanceIdentifier.NodeWithValue child) {
            return Optional.ofNullable(this.children.get(child));
        }

        public LeafSetEntryNode<T> getChild(int position) {
            return (LeafSetEntryNode)Iterables.get(this.children.values(), (int)position);
        }

        @Override
        protected int valueHashCode() {
            return this.children.hashCode();
        }

        private Map<YangInstanceIdentifier.NodeWithValue, LeafSetEntryNode<T>> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }

        @Override
        protected boolean valueEquals(AbstractImmutableNormalizedNode<?, ?> other) {
            return this.children.equals(((ImmutableOrderedLeafSetNode)other).children);
        }

        public int getSize() {
            return this.children.size();
        }

        public Collection<LeafSetEntryNode<T>> getValue() {
            return UnmodifiableCollection.create(this.children.values());
        }
    }
}

