/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractCursorAware;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeSnapshotCursor;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.RootApplyStrategy;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;

final class InMemoryDataTreeSnapshot
extends AbstractCursorAware
implements CursorAwareDataTreeSnapshot,
SchemaContextProvider {
    private final @NonNull RootApplyStrategy applyOper;
    private final @NonNull SchemaContext schemaContext;
    private final @NonNull TreeNode rootNode;

    InMemoryDataTreeSnapshot(SchemaContext schemaContext, TreeNode rootNode, RootApplyStrategy applyOper) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.rootNode = Objects.requireNonNull(rootNode);
        this.applyOper = Objects.requireNonNull(applyOper);
    }

    TreeNode getRootNode() {
        return this.rootNode;
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public Optional<NormalizedNode<?, ?>> readNode(YangInstanceIdentifier path) {
        return NormalizedNodes.findNode((NormalizedNode)this.rootNode.getData(), (YangInstanceIdentifier)path);
    }

    public InMemoryDataTreeModification newModification() {
        return new InMemoryDataTreeModification(this, this.applyOper);
    }

    public Optional<DataTreeSnapshotCursor> openCursor(YangInstanceIdentifier path) {
        return NormalizedNodes.findNode((NormalizedNode)this.rootNode.getData(), (YangInstanceIdentifier)path).map(root -> {
            Preconditions.checkArgument((boolean)(root instanceof NormalizedNodeContainer), (String)"Child %s is not a container", (Object)path);
            return this.openCursor(new InMemoryDataTreeSnapshotCursor(this, path, (NormalizedNodeContainer)root));
        });
    }

    public String toString() {
        return this.rootNode.getSubtreeVersion().toString();
    }
}

