/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableOrderedMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AutomaticLifecycleMixin;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ListEntryModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class MapModificationStrategy
extends AbstractNodeContainerModificationStrategy.Invisible<ListSchemaNode> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, OrderedMapNode> ORDERED_SUPPORT = new NormalizedNodeContainerSupport(OrderedMapNode.class, ChildTrackingPolicy.ORDERED, ImmutableOrderedMapNodeBuilder::create, ImmutableOrderedMapNodeBuilder::create);
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, MapNode> UNORDERED_SUPPORT = new NormalizedNodeContainerSupport(MapNode.class, ImmutableMapNodeBuilder::create, ImmutableMapNodeBuilder::create);
    private final @NonNull MapNode emptyNode;

    private MapModificationStrategy(NormalizedNodeContainerSupport<?, ?> support, ListSchemaNode schema, DataTreeConfiguration treeConfig, MapNode emptyNode) {
        super(support, treeConfig, ListEntryModificationStrategy.of(schema, treeConfig));
        this.emptyNode = Objects.requireNonNull(emptyNode);
    }

    static MapModificationStrategy of(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        OrderedMapNode emptyNode;
        NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, OrderedMapNode> support;
        if (schema.isUserOrdered()) {
            support = ORDERED_SUPPORT;
            emptyNode = ImmutableNodes.orderedMapNode(schema.getQName());
        } else {
            support = UNORDERED_SUPPORT;
            emptyNode = ImmutableNodes.mapNode(schema.getQName());
        }
        return new MapModificationStrategy(support, schema, treeConfig, (MapNode)emptyNode);
    }

    @Override
    public Optional<ModificationApplyOperation> getChild(YangInstanceIdentifier.PathArgument identifier) {
        return identifier instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates ? this.entryStrategy() : Optional.empty();
    }

    @Override
    Optional<TreeNode> apply(ModifiedNode modification, Optional<TreeNode> storeMeta, Version version) {
        return AutomaticLifecycleMixin.apply((x$0, x$1, x$2) -> super.apply(x$0, x$1, x$2), this::applyWrite, this.emptyNode, modification, storeMeta, version);
    }

    @Override
    TreeNode defaultTreeNode() {
        return MapModificationStrategy.defaultTreeNode(this.emptyNode);
    }
}

