/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AugmentationModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ChoiceModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LeafSetModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MapModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MinMaxElementsValidation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModifiedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.NodeModification;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.UnkeyedListModificationStrategy;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ValueNodeModificationStrategy;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SchemaAwareApplyOperation<T extends DocumentedNode.WithStatus>
extends ModificationApplyOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAwareApplyOperation.class);

    SchemaAwareApplyOperation() {
    }

    public static ModificationApplyOperation from(DataSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        if (treeConfig.getTreeType() == TreeType.CONFIGURATION) {
            Preconditions.checkArgument((boolean)schemaNode.isConfiguration(), (String)"Supplied %s does not belongs to configuration tree.", (Object)schemaNode.getPath());
        }
        if (schemaNode instanceof ContainerSchemaNode) {
            return ContainerModificationStrategy.of((ContainerSchemaNode)schemaNode, treeConfig);
        }
        if (schemaNode instanceof ListSchemaNode) {
            return SchemaAwareApplyOperation.fromListSchemaNode((ListSchemaNode)schemaNode, treeConfig);
        }
        if (schemaNode instanceof ChoiceSchemaNode) {
            return new ChoiceModificationStrategy((ChoiceSchemaNode)schemaNode, treeConfig);
        }
        if (schemaNode instanceof LeafListSchemaNode) {
            return MinMaxElementsValidation.from(new LeafSetModificationStrategy((LeafListSchemaNode)schemaNode, treeConfig));
        }
        if (schemaNode instanceof LeafSchemaNode) {
            return new ValueNodeModificationStrategy<LeafSchemaNode>(LeafNode.class, (LeafSchemaNode)schemaNode);
        }
        throw new IllegalArgumentException("Not supported schema node type for " + schemaNode.getClass());
    }

    public static AugmentationModificationStrategy from(DataNodeContainer resolvedTree, AugmentationTarget augSchemas, YangInstanceIdentifier.AugmentationIdentifier identifier, DataTreeConfiguration treeConfig) {
        for (AugmentationSchemaNode potential : augSchemas.getAvailableAugmentations()) {
            for (DataSchemaNode child : potential.getChildNodes()) {
                if (!identifier.getPossibleChildNames().contains(child.getQName())) continue;
                return new AugmentationModificationStrategy(potential, resolvedTree, treeConfig);
            }
        }
        return null;
    }

    static void checkConflicting(ModificationPath path, boolean condition, String message) throws ConflictingModificationAppliedException {
        if (!condition) {
            throw new ConflictingModificationAppliedException(path.toInstanceIdentifier(), message);
        }
    }

    private static ModificationApplyOperation fromListSchemaNode(ListSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        List keyDefinition = schemaNode.getKeyDefinition();
        SchemaAwareApplyOperation op = keyDefinition == null || keyDefinition.isEmpty() ? new UnkeyedListModificationStrategy(schemaNode, treeConfig) : MapModificationStrategy.of(schemaNode, treeConfig);
        return MinMaxElementsValidation.from(op);
    }

    protected static void checkNotConflicting(ModificationPath path, TreeNode original, TreeNode current) throws ConflictingModificationAppliedException {
        SchemaAwareApplyOperation.checkConflicting(path, original.getVersion().equals(current.getVersion()), "Node was replaced by other transaction.");
        SchemaAwareApplyOperation.checkConflicting(path, original.getSubtreeVersion().equals(current.getSubtreeVersion()), "Node children was modified by other transaction");
    }

    protected final ModificationApplyOperation resolveChildOperation(YangInstanceIdentifier.PathArgument child) {
        Optional<ModificationApplyOperation> potential = this.getChild(child);
        Preconditions.checkArgument((boolean)potential.isPresent(), (String)"Operation for child %s is not defined.", (Object)child);
        return potential.get();
    }

    @Override
    final void checkApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        switch (modification.getOperation()) {
            case DELETE: {
                SchemaAwareApplyOperation.checkDeleteApplicable(modification, current);
                break;
            }
            case TOUCH: {
                this.checkTouchApplicable(path, modification, current, version);
                break;
            }
            case WRITE: {
                SchemaAwareApplyOperation.checkWriteApplicable(path, modification, current, version);
                break;
            }
            case MERGE: {
                this.checkMergeApplicable(path, modification, current, version);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Suplied modification type " + (Object)((Object)modification.getOperation()) + " is not supported.");
            }
        }
    }

    @Override
    final void quickVerifyStructure(NormalizedNode<?, ?> writtenValue) {
        this.verifyValue(writtenValue);
    }

    @Override
    final void fullVerifyStructure(NormalizedNode<?, ?> writtenValue) {
        this.verifyValue(writtenValue);
        this.verifyValueChildren(writtenValue);
    }

    abstract void verifyValue(NormalizedNode<?, ?> var1);

    void verifyValueChildren(NormalizedNode<?, ?> writtenValue) {
    }

    protected void checkMergeApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        Optional<TreeNode> original = modification.getOriginal();
        if (original.isPresent() && current.isPresent()) {
            TreeNode orig = original.get();
            TreeNode cur = current.get();
            if (!orig.getData().equals(cur.getData())) {
                SchemaAwareApplyOperation.checkNotConflicting(path, orig, cur);
            }
        }
    }

    private static void checkWriteApplicable(ModificationPath path, NodeModification modification, Optional<TreeNode> current, Version version) throws DataValidationFailedException {
        Optional<TreeNode> original = modification.getOriginal();
        if (original.isPresent() && current.isPresent()) {
            SchemaAwareApplyOperation.checkNotConflicting(path, original.get(), current.get());
        } else {
            SchemaAwareApplyOperation.checkConflicting(path, !original.isPresent(), "Node was deleted by other transaction.");
            SchemaAwareApplyOperation.checkConflicting(path, !current.isPresent(), "Node was created by other transaction.");
        }
    }

    private static void checkDeleteApplicable(NodeModification modification, Optional<TreeNode> current) {
        if (!current.isPresent()) {
            LOG.trace("Delete operation turned to no-op on missing node {}", (Object)modification);
        }
    }

    @Override
    Optional<TreeNode> apply(ModifiedNode modification, Optional<TreeNode> currentMeta, Version version) {
        switch (modification.getOperation()) {
            case DELETE: {
                modification.resolveModificationType(currentMeta.isPresent() ? ModificationType.DELETE : ModificationType.UNMODIFIED);
                return modification.setSnapshot(Optional.empty());
            }
            case TOUCH: {
                Preconditions.checkArgument((boolean)currentMeta.isPresent(), (String)"Metadata not available for modification %s", (Object)modification);
                return modification.setSnapshot(Optional.of(this.applyTouch(modification, currentMeta.get(), version)));
            }
            case MERGE: {
                TreeNode result;
                if (!currentMeta.isPresent()) {
                    modification.resolveModificationType(ModificationType.WRITE);
                    result = this.applyWrite(modification, modification.getWrittenValue(), currentMeta, version);
                    this.fullVerifyStructure(result.getData());
                } else {
                    result = this.applyMerge(modification, currentMeta.get(), version);
                }
                return modification.setSnapshot(Optional.of(result));
            }
            case WRITE: {
                modification.resolveModificationType(ModificationType.WRITE);
                return modification.setSnapshot(Optional.of(this.applyWrite(modification, (NormalizedNode)Verify.verifyNotNull(modification.getWrittenValue()), currentMeta, version)));
            }
            case NONE: {
                modification.resolveModificationType(ModificationType.UNMODIFIED);
                return currentMeta;
            }
        }
        throw new IllegalArgumentException("Provided modification type is not supported.");
    }

    protected abstract TreeNode applyMerge(ModifiedNode var1, TreeNode var2, Version var3);

    protected abstract TreeNode applyWrite(ModifiedNode var1, NormalizedNode<?, ?> var2, Optional<TreeNode> var3, Version var4);

    protected abstract TreeNode applyTouch(ModifiedNode var1, TreeNode var2, Version var3);

    protected abstract void checkTouchApplicable(ModificationPath var1, NodeModification var2, Optional<TreeNode> var3, Version var4) throws DataValidationFailedException;

    abstract @NonNull T getSchema();

    static final boolean belongsToTree(TreeType treeType, DataSchemaNode node) {
        return treeType == TreeType.OPERATIONAL || node.isConfiguration();
    }
}

