/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.codec.BooleanCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;

@Beta
public final class BooleanStringCodec
extends TypeDefinitionAwareCodec<Boolean, BooleanTypeDefinition>
implements BooleanCodec<String> {
    private BooleanStringCodec(@NonNull BooleanTypeDefinition typeDef) {
        super(typeDef, Boolean.class);
    }

    public static @NonNull BooleanStringCodec from(BooleanTypeDefinition normalizedType) {
        return new BooleanStringCodec(Objects.requireNonNull(normalizedType));
    }

    protected Boolean deserializeImpl(String product) {
        switch (product) {
            case "true": {
                return Boolean.TRUE;
            }
            case "false": {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException("Invalid value '" + product + "' for boolean type. Allowed values are 'true' and 'false'");
    }

    protected String serializeImpl(Boolean input) {
        return input.toString();
    }
}

