/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public class SchemaOrderedNormalizedNodeWriter
extends NormalizedNodeWriter {
    private final EffectiveModelContext schemaContext;
    private final SchemaNode root;
    private SchemaNode currentSchemaNode;

    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, EffectiveModelContext schemaContext) {
        super(writer);
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.root = this.schemaContext;
    }

    private SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, SchemaInferenceStack stack) {
        super(writer);
        this.schemaContext = stack.getEffectiveModelContext();
        if (!stack.isEmpty()) {
            EffectiveStatement current = stack.currentStatement();
            Preconditions.checkArgument((boolean)(current instanceof SchemaNode), (String)"Instantiating at %s is not supported", (Object)current);
            this.root = (SchemaNode)current;
        } else {
            this.root = this.schemaContext;
        }
    }

    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, EffectiveModelContext schemaContext, SchemaNodeIdentifier.Absolute path) {
        this(writer, SchemaInferenceStack.of((EffectiveModelContext)schemaContext, (SchemaNodeIdentifier.Absolute)path));
    }

    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, SchemaTreeInference rootInference) {
        this(writer, SchemaInferenceStack.ofInference((SchemaTreeInference)rootInference));
    }

    @Deprecated(since="7.0.11")
    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, EffectiveModelContext schemaContext, SchemaPath path) {
        this(writer, SchemaInferenceStack.ofSchemaPath((EffectiveModelContext)schemaContext, (SchemaPath)path));
    }

    public SchemaOrderedNormalizedNodeWriter write(NormalizedNode node) throws IOException {
        this.currentSchemaNode = this.schemaContext.equals(this.root) ? this.schemaContext.dataChildByName(node.getIdentifier().getNodeType()) : this.root;
        return this.write(node, this.currentSchemaNode);
    }

    public SchemaOrderedNormalizedNodeWriter write(Collection<DataContainerChild> nodes) throws IOException {
        this.currentSchemaNode = this.root;
        if (this.writeChildren(nodes, this.currentSchemaNode, false)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize nodes " + nodes);
    }

    private SchemaOrderedNormalizedNodeWriter write(NormalizedNode node, SchemaNode dataSchemaNode) throws IOException {
        try (SchemaNodeSetter sns = new SchemaNodeSetter(dataSchemaNode);){
            if (node == null) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
            if (this.wasProcessedAsCompositeNode(node)) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
            if (this.wasProcessAsSimpleNode(node)) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    private void write(Collection<NormalizedNode> nodes, SchemaNode dataSchemaNode) throws IOException {
        for (NormalizedNode node : nodes) {
            this.write(node, dataSchemaNode);
        }
    }

    protected boolean writeChildren(Iterable<? extends NormalizedNode> children) throws IOException {
        return this.writeChildren(children, this.currentSchemaNode, true);
    }

    private boolean writeChildren(Iterable<? extends NormalizedNode> children, SchemaNode parentSchemaNode, boolean endParent) throws IOException {
        ArrayListMultimap qnameToNodes = ArrayListMultimap.create();
        for (NormalizedNode normalizedNode : children) {
            SchemaOrderedNormalizedNodeWriter.putChild((Multimap<QName, NormalizedNode>)qnameToNodes, normalizedNode);
        }
        if (parentSchemaNode instanceof DataNodeContainer) {
            if (parentSchemaNode instanceof ListSchemaNode && qnameToNodes.containsKey((Object)parentSchemaNode.getQName())) {
                this.write(qnameToNodes.get((Object)parentSchemaNode.getQName()), parentSchemaNode);
            } else {
                for (DataSchemaNode dataSchemaNode : ((DataNodeContainer)parentSchemaNode).getChildNodes()) {
                    this.write(qnameToNodes.get((Object)dataSchemaNode.getQName()), (SchemaNode)dataSchemaNode);
                }
            }
        } else if (parentSchemaNode instanceof ChoiceSchemaNode) {
            for (CaseSchemaNode caseSchemaNode : ((ChoiceSchemaNode)parentSchemaNode).getCases()) {
                for (DataSchemaNode dsn : caseSchemaNode.getChildNodes()) {
                    if (!qnameToNodes.containsKey((Object)dsn.getQName())) continue;
                    this.write(qnameToNodes.get((Object)dsn.getQName()), (SchemaNode)dsn);
                }
            }
        } else {
            for (NormalizedNode normalizedNode : children) {
                this.writeLeaf(normalizedNode);
            }
        }
        if (endParent) {
            this.getWriter().endNode();
        }
        return true;
    }

    private SchemaOrderedNormalizedNodeWriter writeLeaf(NormalizedNode node) throws IOException {
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + node);
    }

    private static void putChild(Multimap<QName, NormalizedNode> qnameToNodes, NormalizedNode child) {
        if (child instanceof AugmentationNode) {
            for (DataContainerChild grandChild : ((AugmentationNode)child).body()) {
                SchemaOrderedNormalizedNodeWriter.putChild(qnameToNodes, (NormalizedNode)grandChild);
            }
        } else {
            qnameToNodes.put((Object)child.getIdentifier().getNodeType(), (Object)child);
        }
    }

    private final class SchemaNodeSetter
    implements AutoCloseable {
        private final SchemaNode previousSchemaNode;

        SchemaNodeSetter(SchemaNode schemaNode) {
            this.previousSchemaNode = SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode;
            SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode = schemaNode;
        }

        @Override
        public void close() {
            SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode = this.previousSchemaNode;
        }
    }
}

