/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableLeafSetEntryNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.SchemaAwareImmutableLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.nodes.AbstractImmutableNormalizedValueNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;

public class ImmutableLeafSetNodeBuilder<T>
implements ListNodeBuilder<T, SystemLeafSetNode<T>> {
    private static final int DEFAULT_CAPACITY = 4;
    private final Map<YangInstanceIdentifier.NodeWithValue<?>, LeafSetEntryNode<T>> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;

    protected ImmutableLeafSetNodeBuilder() {
        this.value = new HashMap(4);
    }

    protected ImmutableLeafSetNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? Maps.newHashMapWithExpectedSize((int)sizeHint) : new HashMap(4);
    }

    protected ImmutableLeafSetNodeBuilder(ImmutableLeafSetNode<T> node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = MapAdaptor.getDefaultInstance().takeSnapshot(node.children);
    }

    public static <T> @NonNull ListNodeBuilder<T, SystemLeafSetNode<T>> create() {
        return new ImmutableLeafSetNodeBuilder<T>();
    }

    public static <T> @NonNull ListNodeBuilder<T, SystemLeafSetNode<T>> create(int sizeHint) {
        return new ImmutableLeafSetNodeBuilder<T>(sizeHint);
    }

    public static <T> @NonNull ListNodeBuilder<T, SystemLeafSetNode<T>> create(SystemLeafSetNode<T> node) {
        if (node instanceof ImmutableLeafSetNode) {
            return new ImmutableLeafSetNodeBuilder<T>((ImmutableLeafSetNode)node);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + node.getClass());
    }

    @Deprecated(since="6.0.7", forRemoval=true)
    public static <T> @NonNull ListNodeBuilder<T, SystemLeafSetNode<T>> create(LeafListSchemaNode schema) {
        return new SchemaAwareImmutableLeafSetNodeBuilder(schema);
    }

    @Deprecated(since="6.0.7", forRemoval=true)
    public static <T> @NonNull ListNodeBuilder<T, SystemLeafSetNode<T>> create(LeafListSchemaNode schema, LeafSetNode<T> node) {
        if (node instanceof ImmutableLeafSetNode) {
            return new SchemaAwareImmutableLeafSetNodeBuilder(schema, (ImmutableLeafSetNode)node);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + node.getClass());
    }

    public ImmutableLeafSetNodeBuilder<T> withChild(LeafSetEntryNode<T> child) {
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    public ImmutableLeafSetNodeBuilder<T> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.value.remove(key);
        return this;
    }

    public SystemLeafSetNode<T> build() {
        return new ImmutableLeafSetNode(this.nodeIdentifier, MapAdaptor.getDefaultInstance().optimize(this.value));
    }

    public ImmutableLeafSetNodeBuilder<T> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public ImmutableLeafSetNodeBuilder<T> withValue(Collection<LeafSetEntryNode<T>> withValue) {
        for (LeafSetEntryNode<T> leafSetEntry : withValue) {
            this.withChild((LeafSetEntryNode)leafSetEntry);
        }
        return this;
    }

    public ImmutableLeafSetNodeBuilder<T> withChildValue(T childValue) {
        return this.withChild((LeafSetEntryNode)ImmutableLeafSetEntryNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(this.nodeIdentifier.getNodeType(), childValue)).withValue(childValue).build());
    }

    public ImmutableLeafSetNodeBuilder<T> addChild(LeafSetEntryNode<T> child) {
        return this.withChild((LeafSetEntryNode)child);
    }

    public ImmutableLeafSetNodeBuilder<T> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableLeafSetNode<T>
    extends AbstractImmutableNormalizedValueNode<YangInstanceIdentifier.NodeIdentifier, SystemLeafSetNode<?>, Collection<LeafSetEntryNode<T>>>
    implements SystemLeafSetNode<T> {
        private final Map<YangInstanceIdentifier.NodeWithValue<?>, LeafSetEntryNode<T>> children;

        ImmutableLeafSetNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeWithValue<?>, LeafSetEntryNode<T>> children) {
            super(nodeIdentifier, UnmodifiableCollection.create(children.values()));
            this.children = children;
        }

        public LeafSetEntryNode<T> childByArg(YangInstanceIdentifier.NodeWithValue<?> child) {
            return this.children.get(child);
        }

        public int size() {
            return this.children.size();
        }

        protected Class<SystemLeafSetNode<?>> implementedType() {
            return SystemLeafSetNode.class;
        }

        protected int valueHashCode() {
            return this.children.hashCode();
        }

        protected boolean valueEquals(SystemLeafSetNode<?> other) {
            return this.children.equals(((ImmutableLeafSetNode)other).children);
        }
    }
}

