/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.util.UnmodifiableMap;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.SchemaAwareImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.AbstractNormalizedNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class ImmutableMapNodeBuilder
implements CollectionNodeBuilder<MapEntryNode, SystemMapNode> {
    private static final int DEFAULT_CAPACITY = 4;
    private final Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> value;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable YangInstanceIdentifier.NodeIdentifier nodeIdentifier = null;

    protected ImmutableMapNodeBuilder() {
        this.value = new HashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
    }

    protected ImmutableMapNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? Maps.newHashMapWithExpectedSize((int)sizeHint) : new HashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
    }

    protected ImmutableMapNodeBuilder(SystemMapNode node) {
        this.nodeIdentifier = node.getIdentifier();
        this.value = MapAdaptor.getDefaultInstance().takeSnapshot(node instanceof ImmutableMapNode ? ((ImmutableMapNode)node).children : node.asMap());
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> create() {
        return new ImmutableMapNodeBuilder();
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> create(int sizeHint) {
        return new ImmutableMapNodeBuilder(sizeHint);
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> create(SystemMapNode node) {
        return new ImmutableMapNodeBuilder(node);
    }

    @Deprecated(since="6.0.7", forRemoval=true)
    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> create(ListSchemaNode schema) {
        return new SchemaAwareImmutableMapNodeBuilder(schema);
    }

    @Deprecated(since="6.0.7", forRemoval=true)
    public static @NonNull CollectionNodeBuilder<MapEntryNode, SystemMapNode> create(ListSchemaNode schema, MapNode node) {
        if (node instanceof ImmutableMapNode) {
            return new SchemaAwareImmutableMapNodeBuilder(schema, (ImmutableMapNode)node);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + node.getClass());
    }

    public ImmutableMapNodeBuilder withChild(MapEntryNode child) {
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    public ImmutableMapNodeBuilder withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.value.remove(key);
        return this;
    }

    public ImmutableMapNodeBuilder withValue(Collection<MapEntryNode> withValue) {
        for (MapEntryNode mapEntryNode : withValue) {
            this.withChild(mapEntryNode);
        }
        return this;
    }

    public ImmutableMapNodeBuilder withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public SystemMapNode build() {
        return new ImmutableMapNode(this.nodeIdentifier, MapAdaptor.getDefaultInstance().optimize(this.value));
    }

    public ImmutableMapNodeBuilder addChild(MapEntryNode child) {
        return this.withChild(child);
    }

    public ImmutableMapNodeBuilder removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableMapNode
    extends AbstractNormalizedNode<YangInstanceIdentifier.NodeIdentifier, SystemMapNode>
    implements SystemMapNode {
        private final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
        YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children;

        ImmutableMapNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children) {
            super((YangInstanceIdentifier.PathArgument)nodeIdentifier);
            this.children = Objects.requireNonNull(children);
        }

        public MapEntryNode childByArg(YangInstanceIdentifier.NodeIdentifierWithPredicates child) {
            return this.children.get(child);
        }

        public Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> asMap() {
            return UnmodifiableMap.of(this.children);
        }

        public int size() {
            return this.children.size();
        }

        protected Class<SystemMapNode> implementedType() {
            return SystemMapNode.class;
        }

        protected int valueHashCode() {
            return this.children.hashCode();
        }

        protected boolean valueEquals(SystemMapNode other) {
            Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> otherChildren = other instanceof ImmutableMapNode ? ((ImmutableMapNode)other).children : other.asMap();
            return this.children.equals(otherChildren);
        }
    }
}

