/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.util.UnmodifiableMap;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.SchemaAwareImmutableOrderedMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.AbstractNormalizedNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class ImmutableUserMapNodeBuilder
implements CollectionNodeBuilder<MapEntryNode, UserMapNode> {
    private static final int DEFAULT_CAPACITY = 4;
    private Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    ImmutableUserMapNodeBuilder() {
        this.value = new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
        this.dirty = false;
    }

    private ImmutableUserMapNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(sizeHint + sizeHint / 3) : new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
        this.dirty = false;
    }

    ImmutableUserMapNodeBuilder(ImmutableUserMapNode node) {
        this.nodeIdentifier = (YangInstanceIdentifier.NodeIdentifier)node.getIdentifier();
        this.value = node.children;
        this.dirty = true;
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, UserMapNode> create() {
        return new ImmutableUserMapNodeBuilder();
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, UserMapNode> create(int sizeHint) {
        return new ImmutableUserMapNodeBuilder(sizeHint);
    }

    public static @NonNull CollectionNodeBuilder<MapEntryNode, UserMapNode> create(UserMapNode node) {
        if (!(node instanceof ImmutableUserMapNode)) {
            throw new UnsupportedOperationException(String.format("Cannot initialize from class %s", node.getClass()));
        }
        return new ImmutableUserMapNodeBuilder((ImmutableUserMapNode)node);
    }

    @Deprecated(since="6.0.7", forRemoval=true)
    public static @NonNull CollectionNodeBuilder<MapEntryNode, UserMapNode> create(ListSchemaNode schema) {
        return new SchemaAwareImmutableOrderedMapNodeBuilder(schema);
    }

    @Deprecated(since="6.0.7", forRemoval=true)
    public static @NonNull CollectionNodeBuilder<MapEntryNode, UserMapNode> create(ListSchemaNode schema, MapNode node) {
        if (node instanceof ImmutableUserMapNode) {
            return new SchemaAwareImmutableOrderedMapNodeBuilder(schema, (ImmutableUserMapNode)node);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + node.getClass());
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(this.value);
            this.dirty = false;
        }
    }

    public CollectionNodeBuilder<MapEntryNode, UserMapNode> withChild(MapEntryNode child) {
        this.checkDirty();
        this.value.put(child.getIdentifier(), child);
        return this;
    }

    public CollectionNodeBuilder<MapEntryNode, UserMapNode> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    public CollectionNodeBuilder<MapEntryNode, UserMapNode> withValue(Collection<MapEntryNode> withValue) {
        for (MapEntryNode mapEntryNode : withValue) {
            this.withChild(mapEntryNode);
        }
        return this;
    }

    public CollectionNodeBuilder<MapEntryNode, UserMapNode> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public UserMapNode build() {
        this.dirty = true;
        return new ImmutableUserMapNode(this.nodeIdentifier, this.value);
    }

    public CollectionNodeBuilder<MapEntryNode, UserMapNode> addChild(MapEntryNode child) {
        return this.withChild(child);
    }

    public NormalizedNodeContainerBuilder<YangInstanceIdentifier.NodeIdentifier, YangInstanceIdentifier.PathArgument, MapEntryNode, UserMapNode> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    protected static final class ImmutableUserMapNode
    extends AbstractNormalizedNode<YangInstanceIdentifier.NodeIdentifier, UserMapNode>
    implements UserMapNode {
        private final Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children;

        ImmutableUserMapNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children) {
            super((YangInstanceIdentifier.PathArgument)nodeIdentifier);
            this.children = children;
        }

        public MapEntryNode childByArg(YangInstanceIdentifier.NodeIdentifierWithPredicates child) {
            return this.children.get(child);
        }

        public MapEntryNode childAt(int position) {
            return (MapEntryNode)Iterables.get(this.children.values(), (int)position);
        }

        public int size() {
            return this.children.size();
        }

        public Collection<MapEntryNode> body() {
            return UnmodifiableCollection.create(this.children.values());
        }

        public Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> asMap() {
            return UnmodifiableMap.of(this.children);
        }

        protected Class<UserMapNode> implementedType() {
            return UserMapNode.class;
        }

        protected int valueHashCode() {
            int hashCode = 1;
            for (MapEntryNode child : this.children.values()) {
                hashCode = 31 * hashCode + child.hashCode();
            }
            return hashCode;
        }

        protected boolean valueEquals(UserMapNode other) {
            Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> otherChildren = other instanceof ImmutableUserMapNode ? ((ImmutableUserMapNode)other).children : other.asMap();
            return Iterables.elementsEqual(this.children.values(), otherChildren.values());
        }
    }
}

