/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableMapNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

final class SchemaAwareImmutableMapNodeBuilder
extends ImmutableMapNodeBuilder {
    private final ListSchemaNode schema;

    SchemaAwareImmutableMapNodeBuilder(ListSchemaNode schema) {
        this.schema = Objects.requireNonNull(schema);
        super.withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
    }

    SchemaAwareImmutableMapNodeBuilder(ListSchemaNode schema, ImmutableMapNodeBuilder.ImmutableMapNode node) {
        super(node);
        this.schema = Objects.requireNonNull(schema);
        super.withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()));
    }

    @Override
    public ImmutableMapNodeBuilder withChild(MapEntryNode child) {
        YangInstanceIdentifier.NodeIdentifierWithPredicates childId = child.getIdentifier();
        QName qname = this.schema.getQName();
        DataValidationException.checkLegalChild(qname.equals((Object)childId.getNodeType()), (YangInstanceIdentifier.PathArgument)childId, (DataSchemaNode)this.schema, Set.of(qname));
        return super.withChild(child);
    }

    @Override
    public ImmutableMapNodeBuilder withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }
}

