/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.builder.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableUserLeafSetNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.valid.DataValidationException;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;

final class SchemaAwareImmutableOrderedLeafSetNodeBuilder<T>
extends ImmutableUserLeafSetNodeBuilder<T> {
    private final LeafListSchemaNode schema;

    SchemaAwareImmutableOrderedLeafSetNodeBuilder(LeafListSchemaNode schema) {
        this.schema = Objects.requireNonNull(schema);
        super.withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()));
    }

    SchemaAwareImmutableOrderedLeafSetNodeBuilder(LeafListSchemaNode schema, ImmutableUserLeafSetNodeBuilder.ImmutableUserLeafSetNode<T> node) {
        super(node);
        this.schema = Objects.requireNonNull(schema);
        super.withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()));
    }

    @Override
    public ImmutableUserLeafSetNodeBuilder<T> withChildValue(T childValue) {
        return super.withChildValue((Object)childValue);
    }

    @Override
    public ImmutableUserLeafSetNodeBuilder<T> withChild(LeafSetEntryNode<T> child) {
        YangInstanceIdentifier.NodeWithValue childId = child.getIdentifier();
        QName childName = childId.getNodeType();
        QName qname = this.schema.getQName();
        Preconditions.checkArgument((boolean)qname.equals((Object)childName), (String)"Incompatible node type, should be: %s, is: %s", (Object)qname, (Object)childName);
        DataValidationException.checkLegalChild(qname.equals((Object)childName), (YangInstanceIdentifier.PathArgument)childId, (DataSchemaNode)this.schema, Set.of(qname));
        return super.withChild((LeafSetEntryNode)child);
    }

    @Override
    public ImmutableUserLeafSetNodeBuilder<T> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        throw new UnsupportedOperationException("Node identifier created from schema");
    }
}

