/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.jaxen.NamespaceContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

final class ConverterNamespaceContext
extends Converter<String, QNameModule>
implements NamespaceContext {
    private final Converter<String, QNameModule> delegate;

    ConverterNamespaceContext(Converter<String, QNameModule> convertor) {
        this.delegate = (Converter)Preconditions.checkNotNull(convertor);
    }

    protected QNameModule doForward(@Nonnull String a) {
        return (QNameModule)this.delegate.convert((Object)a);
    }

    protected String doBackward(@Nonnull QNameModule b) {
        return (String)this.delegate.reverse().convert((Object)b);
    }

    public String translateNamespacePrefixToUri(String prefix) {
        return ((QNameModule)this.convert(prefix)).getNamespace().toString();
    }

    String jaxenQName(QName qname) {
        return (String)this.reverse().convert((Object)qname.getModule()) + ':' + qname.getLocalName();
    }
}

