/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.CommentNodeStep;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.ProcessingInstructionNodeStep;
import org.jaxen.expr.TextNodeStep;
import org.jaxen.expr.UnaryExpr;
import org.jaxen.expr.VariableReferenceExpr;
import org.opendaylight.yangtools.yang.data.jaxen.ExprListener;
import org.opendaylight.yangtools.yang.data.jaxen.Operator;
import org.opendaylight.yangtools.yang.data.jaxen.StepListener;

final class ExprWalker {
    private final ExprListener listener;

    ExprWalker(ExprListener listener) {
        this.listener = (ExprListener)Preconditions.checkNotNull((Object)listener);
    }

    public void walk(Expr expr) {
        if (expr instanceof BinaryExpr) {
            BinaryExpr binary = (BinaryExpr)expr;
            this.listener.enterBinaryExpr(binary);
            this.walk(binary.getLHS());
            this.listener.visitOperator(Operator.forString(binary.getOperator()));
            this.walk(binary.getRHS());
            this.listener.exitBinaryExpr(binary);
        } else if (expr instanceof FilterExpr) {
            FilterExpr filter = (FilterExpr)expr;
            this.listener.enterFilterExpr(filter);
            this.walk(expr);
            this.listener.exitFilterExpr(filter);
        } else if (expr instanceof FunctionCallExpr) {
            FunctionCallExpr func = (FunctionCallExpr)expr;
            this.listener.enterFunctionCallExpr(func);
            for (Object arg : func.getParameters()) {
                this.walk((Expr)arg);
            }
            this.listener.exitFunctionCallExpr(func);
        } else if (expr instanceof LiteralExpr) {
            this.listener.visitLiteralExpr((LiteralExpr)expr);
        } else if (expr instanceof LocationPath) {
            LocationPath path = (LocationPath)expr;
            Optional<StepListener> maybeListener = this.listener.enterLocationPath(path);
            if (maybeListener.isPresent()) {
                StepListener l = maybeListener.get();
                for (Object step : path.getSteps()) {
                    if (step instanceof AllNodeStep) {
                        l.onAll((AllNodeStep)step);
                        continue;
                    }
                    if (step instanceof CommentNodeStep) {
                        l.onComment((CommentNodeStep)step);
                        continue;
                    }
                    if (step instanceof NameStep) {
                        l.onName((NameStep)step);
                        continue;
                    }
                    if (step instanceof ProcessingInstructionNodeStep) {
                        l.onProcessingInstruction((ProcessingInstructionNodeStep)step);
                        continue;
                    }
                    if (step instanceof TextNodeStep) {
                        l.onTest((TextNodeStep)step);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported step " + step);
                }
            }
            this.listener.exitLocationPath(path);
        } else if (expr instanceof NumberExpr) {
            this.listener.visitNumberExpr((NumberExpr)expr);
        } else if (expr instanceof PathExpr) {
            PathExpr path = (PathExpr)expr;
            this.listener.enterPathExpr(path);
            this.walk(path.getFilterExpr());
            this.walk((Expr)path.getLocationPath());
            this.listener.exitPathExpr(path);
        } else if (expr instanceof UnaryExpr) {
            UnaryExpr unary = (UnaryExpr)expr;
            this.listener.enterNotExpr(unary);
            this.walk(unary.getExpr());
            this.listener.exitNotExpr(unary);
        } else if (expr instanceof VariableReferenceExpr) {
            this.listener.visitVariableReferenceExpr((VariableReferenceExpr)expr);
        } else {
            throw new IllegalArgumentException("Unsupported expression " + expr);
        }
    }
}

