/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.xml.xpath.XPathExpressionException;
import org.jaxen.JaxenException;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathDocument;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathExpression;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathSchemaContext;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenDocument;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class JaxenSchemaContext
implements XPathSchemaContext {
    private final SchemaContext context;

    JaxenSchemaContext(SchemaContext context) {
        this.context = (SchemaContext)Preconditions.checkNotNull((Object)context);
    }

    @Nonnull
    public XPathExpression compileExpression(@Nonnull SchemaPath schemaPath, Converter<String, QNameModule> prefixes, @Nonnull String xpath) throws XPathExpressionException {
        try {
            return JaxenXPath.create(prefixes, schemaPath, xpath);
        }
        catch (JaxenException e) {
            throw new XPathExpressionException(e);
        }
    }

    @Nonnull
    public XPathDocument createDocument(@Nonnull NormalizedNode<?, ?> documentRoot) {
        return new JaxenDocument(this, documentRoot);
    }

    @Nonnull
    SchemaContext getSchemaContext() {
        return this.context;
    }
}

