/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Converter;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.xpath.XPathExpressionException;
import org.jaxen.BaseXPath;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.expr.Expr;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathDocument;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathExpression;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathResult;
import org.opendaylight.yangtools.yang.data.jaxen.ExprListener;
import org.opendaylight.yangtools.yang.data.jaxen.ExprWalker;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenDocument;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContextSupport;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JaxenXPath
implements XPathExpression {
    private static final Logger LOG = LoggerFactory.getLogger(JaxenXPath.class);
    private final Converter<String, QNameModule> converter;
    private final SchemaPath schemaPath;
    private final BaseXPath xpath;

    private JaxenXPath(Converter<String, QNameModule> converter, SchemaPath schemaPath, BaseXPath xpath) {
        this.converter = (Converter)Preconditions.checkNotNull(converter);
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)schemaPath);
        this.xpath = (BaseXPath)Preconditions.checkNotNull((Object)xpath);
    }

    static JaxenXPath create(Converter<String, QNameModule> converter, SchemaPath schemaPath, final String xpath) throws JaxenException {
        BaseXPath compiled = new BaseXPath(xpath){
            private static final long serialVersionUID = 1L;

            protected ContextSupport getContextSupport() {
                throw new UnsupportedOperationException(xpath);
            }
        };
        Expr expr = compiled.getRootExpr();
        LOG.debug("Compiled {} to expression {}", (Object)xpath, (Object)expr);
        new ExprWalker(new ExprListener(){}).walk(expr);
        return new JaxenXPath(converter, schemaPath, compiled);
    }

    public Optional<? extends XPathResult<?>> evaluate(@Nonnull XPathDocument document, @Nonnull YangInstanceIdentifier path) throws XPathExpressionException {
        Object result;
        Preconditions.checkArgument((boolean)(document instanceof JaxenDocument));
        NormalizedNodeContextSupport contextSupport = NormalizedNodeContextSupport.create((JaxenDocument)document, this.converter);
        try {
            result = this.xpath.evaluate((Object)contextSupport.createContext(path));
        }
        catch (JaxenException e) {
            throw new XPathExpressionException(e);
        }
        if (result instanceof String) {
            return Optional.of(() -> (String)result);
        }
        if (result instanceof Number) {
            return Optional.of(() -> (Number)result);
        }
        if (result instanceof Boolean) {
            return Optional.of(() -> (Boolean)result);
        }
        if (result != null) {
            return Optional.of(() -> Lists.transform((List)((List)result), NormalizedNodeContext::getNode));
        }
        return Optional.absent();
    }

    @Nonnull
    public SchemaPath getEvaluationPath() {
        return this.schemaPath;
    }

    @Nonnull
    public SchemaPath getApexPath() {
        return SchemaPath.ROOT;
    }
}

