/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypedSchemaNode;

@Beta
final class LeafrefXPathStringParsingPathArgumentBuilder
implements Builder<List<YangInstanceIdentifier.PathArgument>> {
    private static final String UP_ONE_LEVEL = "..";
    private static final String CURRENT_FUNCTION_INVOCATION_STR = "current()";
    @RegEx
    private static final String NODE_IDENTIFIER_STR = "([A-Za-z_][A-Za-z0-9_\\.-]*:)?([A-Za-z_][A-Za-z0-9_\\.-]*)";
    private static final Pattern NODE_IDENTIFIER_PATTERN = Pattern.compile("([A-Za-z_][A-Za-z0-9_\\.-]*:)?([A-Za-z_][A-Za-z0-9_\\.-]*)");
    private static final CharMatcher WSP = CharMatcher.anyOf((CharSequence)" \t");
    private static final CharMatcher IDENTIFIER_FIRST_CHAR = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_')).precomputed();
    private static final CharMatcher IDENTIFIER = IDENTIFIER_FIRST_CHAR.or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-")).precomputed();
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private static final char SLASH = '/';
    private static final char COLON = ':';
    private static final char EQUALS = '=';
    private static final char PRECONDITION_START = '[';
    private static final char PRECONDITION_END = ']';
    private final String xPathString;
    private final SchemaContext schemaContext;
    private final TypedSchemaNode schemaNode;
    private final NormalizedNodeContext currentNodeCtx;
    private final List<YangInstanceIdentifier.PathArgument> product = new ArrayList<YangInstanceIdentifier.PathArgument>();
    private int offset = 0;

    LeafrefXPathStringParsingPathArgumentBuilder(String xPathString, SchemaContext schemaContext, TypedSchemaNode schemaNode, NormalizedNodeContext currentNodeCtx) {
        this.xPathString = xPathString;
        this.schemaContext = schemaContext;
        this.schemaNode = schemaNode;
        this.currentNodeCtx = currentNodeCtx;
    }

    public List<YangInstanceIdentifier.PathArgument> build() {
        while (!this.allCharactersConsumed()) {
            this.product.add(this.computeNextArgument());
        }
        return ImmutableList.copyOf(this.product);
    }

    private YangInstanceIdentifier.PathArgument computeNextArgument() {
        this.checkValid('/' == this.currentChar(), "Identifier must start with '/'.", new Object[0]);
        this.skipCurrentChar();
        this.checkValid(!this.allCharactersConsumed(), "Identifier cannot end with '/'.", new Object[0]);
        QName name = this.nextQName();
        if (this.allCharactersConsumed() || '/' == this.currentChar()) {
            return new YangInstanceIdentifier.NodeIdentifier(name);
        }
        this.checkValid('[' == this.currentChar(), "Last element must be identifier, predicate or '/'", new Object[0]);
        return this.computeIdentifierWithPredicate(name);
    }

    private YangInstanceIdentifier.PathArgument computeIdentifierWithPredicate(QName name) {
        this.product.add((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(name));
        ImmutableMap.Builder keyValues = ImmutableMap.builder();
        while (!this.allCharactersConsumed() && '[' == this.currentChar()) {
            this.skipCurrentChar();
            this.skipWhitespaces();
            QName key = this.nextQName();
            this.skipWhitespaces();
            this.checkCurrentAndSkip('=', "Precondition must contain '='");
            this.skipWhitespaces();
            Object keyValue = this.nextCurrentFunctionPathValue();
            this.skipWhitespaces();
            this.checkCurrentAndSkip(']', "Precondition must ends with ']'");
            keyValues.put((Object)key, keyValue);
        }
        return new YangInstanceIdentifier.NodeIdentifierWithPredicates(name, (Map)keyValues.build());
    }

    private Object nextCurrentFunctionPathValue() {
        String xPathSubStr = this.xPathString.substring(this.offset);
        String pathKeyExpression = xPathSubStr.substring(0, xPathSubStr.indexOf(93));
        String relPathKeyExpression = pathKeyExpression.substring(CURRENT_FUNCTION_INVOCATION_STR.length());
        this.offset += CURRENT_FUNCTION_INVOCATION_STR.length();
        this.skipWhitespaces();
        this.checkCurrentAndSkip('/', "Expression 'current()' must be followed by slash.");
        this.skipWhitespaces();
        List pathComponents = SLASH_SPLITTER.trimResults().omitEmptyStrings().splitToList((CharSequence)relPathKeyExpression);
        this.checkValid(!pathComponents.isEmpty(), "Malformed path key expression: '%s'.", pathKeyExpression);
        boolean inNodeIdentifierPart = false;
        NormalizedNodeContext currentNodeCtx = this.currentNodeCtx;
        NormalizedNode<?, ?> currentNode = null;
        for (String pathComponent : pathComponents) {
            Matcher matcher = NODE_IDENTIFIER_PATTERN.matcher(pathComponent);
            if (UP_ONE_LEVEL.equals(pathComponent)) {
                this.checkValid(!inNodeIdentifierPart, "Up-one-level expression cannot follow concrete path component.", new Object[0]);
                currentNodeCtx = currentNodeCtx.getParent();
                currentNode = currentNodeCtx.getNode();
                this.offset += UP_ONE_LEVEL.length() + 1;
                continue;
            }
            if (matcher.matches()) {
                inNodeIdentifierPart = true;
                if (currentNode == null || !(currentNode instanceof DataContainerNode)) continue;
                DataContainerNode dcn = (DataContainerNode)currentNode;
                Optional possibleChild = dcn.getChild((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(this.nextQName()));
                currentNode = possibleChild.isPresent() ? (NormalizedNode)possibleChild.get() : null;
                continue;
            }
            throw new IllegalArgumentException(String.format("Could not parse leafref path '%s'. Offset: %s : Reason: Malformed path component: '%s'.", this.xPathString, this.offset, pathComponent));
        }
        if (currentNode != null && currentNode instanceof LeafNode) {
            return currentNode.getValue();
        }
        throw new IllegalArgumentException("Could not resolve current function path value.");
    }

    private QName nextQName() {
        String localName;
        String prefix;
        String maybePrefix = this.nextIdentifier();
        if (!this.allCharactersConsumed() && ':' == this.currentChar()) {
            prefix = maybePrefix;
            this.skipCurrentChar();
            localName = this.nextIdentifier();
        } else {
            prefix = "";
            localName = maybePrefix;
        }
        return this.createQName(prefix, localName);
    }

    private boolean allCharactersConsumed() {
        return this.offset == this.xPathString.length();
    }

    private QName createQName(String prefix, String localName) {
        Module module = this.schemaContext.findModuleByNamespaceAndRevision(this.schemaNode.getQName().getNamespace(), this.schemaNode.getQName().getRevision());
        if (prefix.isEmpty() || module.getPrefix().equals(prefix)) {
            return QName.create((QNameModule)module.getQNameModule(), (String)localName);
        }
        for (ModuleImport moduleImport : module.getImports()) {
            if (!prefix.equals(moduleImport.getPrefix())) continue;
            Module importedModule = this.schemaContext.findModuleByName(moduleImport.getModuleName(), moduleImport.getRevision());
            return QName.create((QNameModule)importedModule.getQNameModule(), (String)localName);
        }
        throw new IllegalArgumentException(String.format("Failed to lookup a module for prefix %s", prefix));
    }

    private void checkCurrentAndSkip(char expected, String errorMsg) {
        this.checkValid(expected == this.currentChar(), errorMsg, new Object[0]);
        ++this.offset;
    }

    private void checkValid(boolean condition, String errorMsg, Object ... attributes) {
        if (!condition) {
            throw new IllegalArgumentException(String.format("Could not parse leafref path '%s'. Offset: %s : Reason: %s", this.xPathString, this.offset, String.format(errorMsg, attributes)));
        }
    }

    private char currentChar() {
        return this.xPathString.charAt(this.offset);
    }

    private void skipCurrentChar() {
        ++this.offset;
    }

    private void skipWhitespaces() {
        this.nextSequenceEnd(WSP);
    }

    private String nextIdentifier() {
        int start = this.offset;
        this.checkValid(IDENTIFIER_FIRST_CHAR.matches(this.currentChar()), "Identifier must start with character from set 'a-zA-Z_'", new Object[0]);
        this.nextSequenceEnd(IDENTIFIER);
        return this.xPathString.substring(start, this.offset);
    }

    private void nextSequenceEnd(CharMatcher matcher) {
        while (!this.allCharactersConsumed() && matcher.matches(this.xPathString.charAt(this.offset))) {
            ++this.offset;
        }
    }
}

