/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class NormalizedNodeContext
extends Context
implements Function<NormalizedNode<?, ?>, NormalizedNodeContext> {
    private static final long serialVersionUID = 1L;
    private final NormalizedNodeContext parent;
    private final NormalizedNode<?, ?> node;

    NormalizedNodeContext(@Nonnull ContextSupport contextSupport, @Nonnull NormalizedNode<?, ?> node, @Nullable NormalizedNodeContext parent) {
        super(contextSupport);
        this.node = (NormalizedNode)Preconditions.checkNotNull(node);
        this.parent = parent;
        this.setNodeSet((List)ImmutableList.of((Object)((Object)this)));
    }

    @Nullable
    NormalizedNodeContext getParent() {
        return this.parent;
    }

    @Nonnull
    NormalizedNode<?, ?> getNode() {
        return this.node;
    }

    public NormalizedNodeContext apply(NormalizedNode<?, ?> input) {
        return new NormalizedNodeContext(this.getContextSupport(), input, this);
    }
}

