/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenRuntimeException;
import org.jaxen.UnresolvableException;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPathFunctionContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.jaxen.LeafrefXPathStringParsingPathArgumentBuilder;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContextSupport;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeNavigator;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.RegexUtils;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

final class YangFunctionContext
implements FunctionContext {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Double DOUBLE_NAN = Double.NaN;
    private static final FunctionContext XPATH_FUNCTION_CONTEXT = new XPathFunctionContext(false);
    private static final Function CURRENT_FUNCTION = (context, args) -> {
        if (!args.isEmpty()) {
            throw new FunctionCallException("current() takes no arguments.");
        }
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context %s", (Object[])new Object[]{context.getClass()});
        return (NormalizedNodeContext)context;
    };
    private static final Function REMATCH_FUNCTION = (context, args) -> {
        if (args == null || args.size() != 2) {
            throw new FunctionCallException("re-match() takes two arguments: string subject, string pattern.");
        }
        if (!(args.get(0) instanceof String)) {
            throw new FunctionCallException("First argument of re-match() should be a String.");
        }
        if (!(args.get(1) instanceof String)) {
            throw new FunctionCallException("Second argument of re-match() should be a String.");
        }
        String subject = (String)args.get(0);
        String rawPattern = (String)args.get(1);
        String pattern = RegexUtils.getJavaRegexFromXSD((String)rawPattern);
        return subject.matches(pattern);
    };
    private static final Function DEREF_FUNCTION = (context, args) -> {
        if (!args.isEmpty()) {
            throw new FunctionCallException("deref() takes only one argument: node-set nodes.");
        }
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context %s", (Object[])new Object[]{context.getClass()});
        NormalizedNodeContext currentNodeContext = (NormalizedNodeContext)context;
        SchemaContext schemaContext = YangFunctionContext.getSchemaContext(currentNodeContext);
        TypedSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(schemaContext, currentNodeContext);
        Object nodeValue = currentNodeContext.getNode().getValue();
        if (correspondingSchemaNode.getType() instanceof InstanceIdentifierTypeDefinition && nodeValue instanceof YangInstanceIdentifier) {
            return YangFunctionContext.getNodeReferencedByInstanceIdentifier((YangInstanceIdentifier)nodeValue, currentNodeContext);
        }
        if (correspondingSchemaNode.getType() instanceof LeafrefTypeDefinition) {
            LeafrefTypeDefinition leafrefType = (LeafrefTypeDefinition)correspondingSchemaNode.getType();
            RevisionAwareXPath xPath = leafrefType.getPathStatement();
            return YangFunctionContext.getNodeReferencedByLeafref(xPath, currentNodeContext, schemaContext, correspondingSchemaNode, nodeValue);
        }
        return null;
    };
    private static final Function DERIVED_FROM_FUNCTION = (context, args) -> {
        if (args == null || args.size() != 1) {
            throw new FunctionCallException("derived-from() takes two arguments: node-set nodes, string identity.");
        }
        if (!(args.get(0) instanceof String)) {
            throw new FunctionCallException("Argument 'identity' of derived-from() function should be a String.");
        }
        String identityArg = (String)args.get(0);
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context %s", (Object[])new Object[]{context.getClass()});
        NormalizedNodeContext currentNodeContext = (NormalizedNodeContext)context;
        SchemaContext schemaContext = YangFunctionContext.getSchemaContext(currentNodeContext);
        TypedSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(schemaContext, currentNodeContext);
        if (!(correspondingSchemaNode.getType() instanceof IdentityrefTypeDefinition)) {
            return Boolean.FALSE;
        }
        if (!(currentNodeContext.getNode().getValue() instanceof QName)) {
            return Boolean.FALSE;
        }
        QName currentNodeValue = (QName)currentNodeContext.getNode().getValue();
        IdentitySchemaNode identityArgSchemaNode = YangFunctionContext.getIdentitySchemaNodeFromString(identityArg, schemaContext, correspondingSchemaNode);
        IdentitySchemaNode currentNodeIdentitySchemaNode = YangFunctionContext.getIdentitySchemaNodeFromQName(currentNodeValue, schemaContext);
        HashSet<IdentitySchemaNode> ancestorIdentities = new HashSet<IdentitySchemaNode>();
        YangFunctionContext.collectAncestorIdentities(currentNodeIdentitySchemaNode, ancestorIdentities);
        return ancestorIdentities.contains(identityArgSchemaNode);
    };
    private static final Function DERIVED_FROM_OR_SELF_FUNCTION = (context, args) -> {
        if (args == null || args.size() != 1) {
            throw new FunctionCallException("derived-from-or-self() takes two arguments: node-set nodes, string identity");
        }
        if (!(args.get(0) instanceof String)) {
            throw new FunctionCallException("Argument 'identity' of derived-from-or-self() function should be a String.");
        }
        String identityArg = (String)args.get(0);
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context %s", (Object[])new Object[]{context.getClass()});
        NormalizedNodeContext currentNodeContext = (NormalizedNodeContext)context;
        SchemaContext schemaContext = YangFunctionContext.getSchemaContext(currentNodeContext);
        TypedSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(schemaContext, currentNodeContext);
        if (!(correspondingSchemaNode.getType() instanceof IdentityrefTypeDefinition)) {
            return Boolean.FALSE;
        }
        if (!(currentNodeContext.getNode().getValue() instanceof QName)) {
            return Boolean.FALSE;
        }
        QName currentNodeValue = (QName)currentNodeContext.getNode().getValue();
        IdentitySchemaNode identityArgSchemaNode = YangFunctionContext.getIdentitySchemaNodeFromString(identityArg, schemaContext, correspondingSchemaNode);
        IdentitySchemaNode currentNodeIdentitySchemaNode = YangFunctionContext.getIdentitySchemaNodeFromQName(currentNodeValue, schemaContext);
        if (currentNodeIdentitySchemaNode.equals(identityArgSchemaNode)) {
            return Boolean.TRUE;
        }
        HashSet<IdentitySchemaNode> ancestorIdentities = new HashSet<IdentitySchemaNode>();
        YangFunctionContext.collectAncestorIdentities(currentNodeIdentitySchemaNode, ancestorIdentities);
        return ancestorIdentities.contains(identityArgSchemaNode);
    };
    private static final Function ENUM_VALUE_FUNCTION = (context, args) -> {
        if (!args.isEmpty()) {
            throw new FunctionCallException("enum-value() takes one argument: node-set nodes.");
        }
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context %s", (Object[])new Object[]{context.getClass()});
        NormalizedNodeContext currentNodeContext = (NormalizedNodeContext)context;
        SchemaContext schemaContext = YangFunctionContext.getSchemaContext(currentNodeContext);
        TypedSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(schemaContext, currentNodeContext);
        TypeDefinition nodeType = correspondingSchemaNode.getType();
        if (!(nodeType instanceof EnumTypeDefinition)) {
            return DOUBLE_NAN;
        }
        Object nodeValue = currentNodeContext.getNode().getValue();
        if (!(nodeValue instanceof String)) {
            return DOUBLE_NAN;
        }
        EnumTypeDefinition enumerationType = (EnumTypeDefinition)nodeType;
        String enumName = (String)nodeValue;
        return YangFunctionContext.getEnumValue(enumerationType, enumName);
    };
    private static final Function BIT_IS_SET_FUNCTION = (context, args) -> {
        if (args == null || args.size() != 1) {
            throw new FunctionCallException("bit-is-set() takes two arguments: node-set nodes, string bit-name");
        }
        if (!(args.get(0) instanceof String)) {
            throw new FunctionCallException("Argument bit-name of bit-is-set() function should be a String");
        }
        String bitName = (String)args.get(0);
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context %s", (Object[])new Object[]{context.getClass()});
        NormalizedNodeContext currentNodeContext = (NormalizedNodeContext)context;
        SchemaContext schemaContext = YangFunctionContext.getSchemaContext(currentNodeContext);
        TypedSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(schemaContext, currentNodeContext);
        TypeDefinition nodeType = correspondingSchemaNode.getType();
        if (!(nodeType instanceof BitsTypeDefinition)) {
            return Boolean.FALSE;
        }
        Object nodeValue = currentNodeContext.getNode().getValue();
        if (!(nodeValue instanceof Set)) {
            return Boolean.FALSE;
        }
        BitsTypeDefinition bitsType = (BitsTypeDefinition)nodeType;
        Preconditions.checkState((boolean)YangFunctionContext.containsBit(bitsType, bitName), (String)"Bit %s does not belong to bits %s.", (Object[])new Object[]{bitName, bitsType});
        return ((Set)nodeValue).contains(bitName);
    };
    private static final YangFunctionContext INSTANCE = new YangFunctionContext();

    private static NormalizedNode<?, ?> getNodeReferencedByInstanceIdentifier(YangInstanceIdentifier path, NormalizedNodeContext currentNodeContext) {
        List relPath;
        Optional possibleNode;
        NormalizedNodeNavigator navigator = (NormalizedNodeNavigator)currentNodeContext.getNavigator();
        NormalizedNode<?, ?> rootNode = navigator.getRootNode();
        List pathArguments = path.getPathArguments();
        if (((YangInstanceIdentifier.PathArgument)pathArguments.get(0)).getNodeType().equals((Object)rootNode.getNodeType()) && (possibleNode = NormalizedNodes.findNode(rootNode, relPath = pathArguments.subList(1, pathArguments.size()))).isPresent()) {
            return (NormalizedNode)possibleNode.get();
        }
        return null;
    }

    private static NormalizedNode<?, ?> getNodeReferencedByLeafref(RevisionAwareXPath xPath, NormalizedNodeContext currentNodeContext, SchemaContext schemaContext, TypedSchemaNode correspondingSchemaNode, Object nodeValue) {
        NormalizedNode<?, ?> referencedNode;
        NormalizedNode<?, ?> normalizedNode = referencedNode = xPath.isAbsolute() ? YangFunctionContext.getNodeReferencedByAbsoluteLeafref(xPath, currentNodeContext, schemaContext, correspondingSchemaNode) : YangFunctionContext.getNodeReferencedByRelativeLeafref(xPath, currentNodeContext, schemaContext, correspondingSchemaNode);
        if (referencedNode instanceof LeafSetNode) {
            return YangFunctionContext.getReferencedLeafSetEntryNode((LeafSetNode)referencedNode, nodeValue);
        }
        if (referencedNode instanceof LeafNode && referencedNode.getValue().equals(nodeValue)) {
            return referencedNode;
        }
        return null;
    }

    private static NormalizedNode<?, ?> getNodeReferencedByAbsoluteLeafref(RevisionAwareXPath xPath, NormalizedNodeContext currentNodeContext, SchemaContext schemaContext, TypedSchemaNode correspondingSchemaNode) {
        List relPath;
        Optional possibleNode;
        LeafrefXPathStringParsingPathArgumentBuilder builder = new LeafrefXPathStringParsingPathArgumentBuilder(xPath.toString(), schemaContext, correspondingSchemaNode, currentNodeContext);
        Object pathArguments = builder.build();
        NormalizedNodeNavigator navigator = (NormalizedNodeNavigator)currentNodeContext.getNavigator();
        NormalizedNode<?, ?> rootNode = navigator.getRootNode();
        if (((YangInstanceIdentifier.PathArgument)pathArguments.get(0)).getNodeType().equals((Object)rootNode.getNodeType()) && (possibleNode = NormalizedNodes.findNode(rootNode, relPath = pathArguments.subList(1, pathArguments.size()))).isPresent()) {
            return (NormalizedNode)possibleNode.get();
        }
        return null;
    }

    private static NormalizedNode<?, ?> getNodeReferencedByRelativeLeafref(RevisionAwareXPath xPath, NormalizedNodeContext currentNodeContext, SchemaContext schemaContext, TypedSchemaNode correspondingSchemaNode) {
        NormalizedNodeContext relativeNodeContext = currentNodeContext;
        StringBuilder xPathStringBuilder = new StringBuilder(xPath.toString());
        while (xPathStringBuilder.indexOf("../") == 0) {
            xPathStringBuilder.delete(0, 3);
            relativeNodeContext = relativeNodeContext.getParent();
        }
        xPathStringBuilder.insert(0, '/');
        LeafrefXPathStringParsingPathArgumentBuilder builder = new LeafrefXPathStringParsingPathArgumentBuilder(xPathStringBuilder.toString(), schemaContext, correspondingSchemaNode, currentNodeContext);
        Object pathArguments = builder.build();
        NormalizedNode<?, ?> relativeNode = relativeNodeContext.getNode();
        Optional possibleNode = NormalizedNodes.findNode(relativeNode, (Iterable)pathArguments);
        if (possibleNode.isPresent()) {
            return (NormalizedNode)possibleNode.get();
        }
        return null;
    }

    private static LeafSetEntryNode<?> getReferencedLeafSetEntryNode(LeafSetNode<?> referencedNode, Object currentNodeValue) {
        for (LeafSetEntryNode entryNode : referencedNode.getValue()) {
            if (!currentNodeValue.equals(entryNode.getValue())) continue;
            return entryNode;
        }
        return null;
    }

    private static void collectAncestorIdentities(IdentitySchemaNode identity, Set<IdentitySchemaNode> ancestorIdentities) {
        for (IdentitySchemaNode id : identity.getBaseIdentities()) {
            YangFunctionContext.collectAncestorIdentities(id, ancestorIdentities);
            ancestorIdentities.add(id);
        }
    }

    private static IdentitySchemaNode getIdentitySchemaNodeFromQName(QName identityQName, SchemaContext schemaContext) {
        Module module = schemaContext.findModuleByNamespaceAndRevision(identityQName.getNamespace(), identityQName.getRevision());
        return YangFunctionContext.findIdentitySchemaNodeInModule(module, identityQName);
    }

    private static IdentitySchemaNode getIdentitySchemaNodeFromString(String identity, SchemaContext schemaContext, TypedSchemaNode correspondingSchemaNode) {
        List identityPrefixAndName = COLON_SPLITTER.splitToList((CharSequence)identity);
        Module module = schemaContext.findModuleByNamespaceAndRevision(correspondingSchemaNode.getQName().getNamespace(), correspondingSchemaNode.getQName().getRevision());
        if (identityPrefixAndName.size() == 2) {
            if (((String)identityPrefixAndName.get(0)).equals(module.getPrefix())) {
                return YangFunctionContext.findIdentitySchemaNodeInModule(module, QName.create((QNameModule)module.getQNameModule(), (String)((String)identityPrefixAndName.get(1))));
            }
            for (ModuleImport moduleImport : module.getImports()) {
                if (!((String)identityPrefixAndName.get(0)).equals(moduleImport.getPrefix())) continue;
                Module importedModule = schemaContext.findModuleByName(moduleImport.getModuleName(), moduleImport.getRevision());
                return YangFunctionContext.findIdentitySchemaNodeInModule(importedModule, QName.create((QNameModule)importedModule.getQNameModule(), (String)((String)identityPrefixAndName.get(1))));
            }
            throw new IllegalArgumentException(String.format("Cannot resolve prefix '%s' from identity '%s'.", identityPrefixAndName.get(0), identity));
        }
        if (identityPrefixAndName.size() == 1) {
            return YangFunctionContext.findIdentitySchemaNodeInModule(module, QName.create((QNameModule)module.getQNameModule(), (String)((String)identityPrefixAndName.get(0))));
        }
        throw new IllegalArgumentException(String.format("Malformed identity argument: %s.", identity));
    }

    private static IdentitySchemaNode findIdentitySchemaNodeInModule(Module module, QName identityQName) {
        for (IdentitySchemaNode id : module.getIdentities()) {
            if (!identityQName.equals((Object)id.getQName())) continue;
            return id;
        }
        throw new IllegalArgumentException(String.format("Identity %s does not have a corresponding identity schema node in the module %s.", identityQName, module));
    }

    private static int getEnumValue(EnumTypeDefinition enumerationType, String enumName) {
        for (EnumTypeDefinition.EnumPair enumPair : enumerationType.getValues()) {
            if (!enumName.equals(enumPair.getName())) continue;
            return enumPair.getValue();
        }
        throw new IllegalStateException(String.format("Enum %s does not belong to enumeration %s.", enumName, enumerationType));
    }

    private static boolean containsBit(BitsTypeDefinition bitsType, String bitName) {
        for (BitsTypeDefinition.Bit bit : bitsType.getBits()) {
            if (!bitName.equals(bit.getName())) continue;
            return true;
        }
        return false;
    }

    private static SchemaContext getSchemaContext(NormalizedNodeContext normalizedNodeContext) {
        ContextSupport contextSupport = normalizedNodeContext.getContextSupport();
        Verify.verify((boolean)(contextSupport instanceof NormalizedNodeContextSupport), (String)"Unhandled context support %s", (Object[])new Object[]{contextSupport.getClass()});
        return ((NormalizedNodeContextSupport)contextSupport).getSchemaContext();
    }

    private static TypedSchemaNode getCorrespondingTypedSchemaNode(SchemaContext schemaContext, NormalizedNodeContext currentNodeContext) {
        Iterator ancestorOrSelfAxisIterator;
        try {
            ancestorOrSelfAxisIterator = currentNodeContext.getContextSupport().getNavigator().getAncestorOrSelfAxisIterator((Object)currentNodeContext);
        }
        catch (UnsupportedAxisException ex) {
            throw new JaxenRuntimeException((Throwable)ex);
        }
        ArrayDeque<QName> schemaPathToCurrentNode = new ArrayDeque<QName>();
        while (ancestorOrSelfAxisIterator.hasNext()) {
            NormalizedNode<?, ?> nextNode = ((NormalizedNodeContext)((Object)ancestorOrSelfAxisIterator.next())).getNode();
            if (nextNode instanceof MapNode || nextNode instanceof LeafSetNode || nextNode instanceof AugmentationNode) continue;
            schemaPathToCurrentNode.addFirst(nextNode.getNodeType());
        }
        SchemaNode schemaNode = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)schemaContext, schemaPathToCurrentNode);
        Preconditions.checkNotNull((Object)schemaNode, (String)"Node %s does not have a corresponding SchemaNode in the SchemaContext.", (Object[])new Object[]{currentNodeContext.getNode()});
        Preconditions.checkState((boolean)(schemaNode instanceof TypedSchemaNode), (String)"Node %s must be a leaf or a leaf-list.", (Object[])new Object[]{currentNodeContext.getNode()});
        return (TypedSchemaNode)schemaNode;
    }

    private YangFunctionContext() {
    }

    static YangFunctionContext getInstance() {
        return INSTANCE;
    }

    public Function getFunction(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        if (prefix == null) {
            switch (localName) {
                case "bit-is-set": {
                    return BIT_IS_SET_FUNCTION;
                }
                case "current": {
                    return CURRENT_FUNCTION;
                }
                case "deref": {
                    return DEREF_FUNCTION;
                }
                case "derived-from": {
                    return DERIVED_FROM_FUNCTION;
                }
                case "derived-from-or-self": {
                    return DERIVED_FROM_OR_SELF_FUNCTION;
                }
                case "enum-value": {
                    return ENUM_VALUE_FUNCTION;
                }
                case "re-match": {
                    return REMATCH_FUNCTION;
                }
            }
        }
        return XPATH_FUNCTION_CONTEXT.getFunction(namespaceURI, prefix, localName);
    }
}

