/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Converter;
import java.util.Objects;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.jaxen.JaxenException;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathDocument;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathExpression;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathSchemaContext;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenDocument;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenXPath;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@NonNullByDefault
final class JaxenSchemaContext
implements XPathSchemaContext {
    private final DataSchemaContextTree tree;
    private final SchemaContext context;

    JaxenSchemaContext(SchemaContext context) {
        this.context = Objects.requireNonNull(context);
        this.tree = DataSchemaContextTree.from((SchemaContext)context);
    }

    public XPathExpression compileExpression(SchemaPath schemaPath, Converter<String, QNameModule> prefixes, String xpath) throws XPathExpressionException {
        try {
            return JaxenXPath.create(prefixes, schemaPath, xpath);
        }
        catch (JaxenException e) {
            throw new XPathExpressionException(e);
        }
    }

    public XPathDocument createDocument(NormalizedNode<?, ?> documentRoot) {
        return new JaxenDocument(this.context, this.tree, documentRoot);
    }
}

