/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jdt.annotation.NonNull;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.Expr;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathSyntaxException;
import org.jaxen.saxpath.base.XPathReader;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathDocument;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathExpression;
import org.opendaylight.yangtools.yang.data.api.schema.xpath.XPathResult;
import org.opendaylight.yangtools.yang.data.jaxen.ExprListener;
import org.opendaylight.yangtools.yang.data.jaxen.ExprWalker;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenDocument;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContextSupport;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JaxenXPath
implements XPathExpression {
    private static final Logger LOG = LoggerFactory.getLogger(JaxenXPath.class);
    private final @NonNull Converter<String, QNameModule> converter;
    private final @NonNull SchemaPath schemaPath;
    private final @NonNull Expr expr;

    private JaxenXPath(@NonNull Converter<String, QNameModule> converter, @NonNull SchemaPath schemaPath, @NonNull Expr expr) {
        this.converter = Objects.requireNonNull(converter);
        this.schemaPath = Objects.requireNonNull(schemaPath);
        this.expr = Objects.requireNonNull(expr);
    }

    static @NonNull JaxenXPath create(@NonNull Converter<String, QNameModule> converter, @NonNull SchemaPath schemaPath, @NonNull String xpath) throws JaxenException {
        Expr parsed;
        try {
            XPathReader reader = new XPathReader();
            JaxenHandler handler = new JaxenHandler();
            reader.setXPathHandler((XPathHandler)handler);
            reader.parse(xpath);
            parsed = handler.getXPathExpr().getRootExpr();
        }
        catch (XPathSyntaxException e) {
            throw new org.jaxen.XPathSyntaxException(e);
        }
        catch (SAXPathException e) {
            throw new JaxenException((Throwable)e);
        }
        LOG.debug("Compiled {} to expression {}", (Object)xpath, (Object)parsed);
        new ExprWalker(new ExprListener(){}).walk(parsed);
        return new JaxenXPath(converter, schemaPath, parsed);
    }

    public Optional<? extends XPathResult<?>> evaluate(XPathDocument document, YangInstanceIdentifier path) throws XPathExpressionException {
        Preconditions.checkArgument((boolean)(document instanceof JaxenDocument));
        NormalizedNodeContextSupport contextSupport = NormalizedNodeContextSupport.create((JaxenDocument)document, this.converter);
        Object result = this.evaluate(contextSupport.createContext(path));
        if (result instanceof String) {
            return Optional.of(() -> (String)result);
        }
        if (result instanceof Number) {
            return Optional.of(() -> (Number)result);
        }
        if (result instanceof Boolean) {
            return Optional.of(() -> (Boolean)result);
        }
        if (result == null) {
            return Optional.empty();
        }
        Verify.verify((boolean)(result instanceof List), (String)"Unhandled result %s", (Object)result);
        List resultList = (List)result;
        return Optional.of(() -> Lists.transform((List)resultList, context -> new AbstractMap.SimpleImmutableEntry(context.getPath(), context.getNode())));
    }

    private Object evaluate(NormalizedNodeContext context) throws XPathExpressionException {
        Object first;
        List list;
        Object result;
        try {
            result = this.expr.evaluate((Context)context);
        }
        catch (JaxenException e) {
            throw new XPathExpressionException(e);
        }
        if (result instanceof List && (list = (List)result).size() == 1 && ((first = list.get(0)) instanceof String || first instanceof Number || first instanceof Boolean)) {
            return first;
        }
        return result;
    }

    public SchemaPath getEvaluationPath() {
        return this.schemaPath;
    }

    public SchemaPath getApexPath() {
        return SchemaPath.ROOT;
    }
}

