/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenDocument;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContextSupport;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

@NonNullByDefault
final class NormalizedNodeContext
extends Context {
    private static final long serialVersionUID = 1L;
    private final @Nullable NormalizedNodeContext parent;
    private final DataSchemaContextNode<?> schema;
    private final NormalizedNode<?, ?> node;

    private NormalizedNodeContext(ContextSupport contextSupport, DataSchemaContextNode<?> schema, NormalizedNode<?, ?> node, @Nullable NormalizedNodeContext parent) {
        super(contextSupport);
        this.schema = Objects.requireNonNull(schema);
        this.node = Objects.requireNonNull(node);
        this.parent = parent;
        this.setNodeSet((List)ImmutableList.of((Object)((Object)this)));
    }

    static NormalizedNodeContext forRoot(NormalizedNodeContextSupport contextSupport) {
        JaxenDocument document = contextSupport.getNavigator().getDocument();
        return new NormalizedNodeContext(contextSupport, document.getSchema(), document.getRootNode(), null);
    }

    NormalizedNode<?, ?> getNode() {
        return this.node;
    }

    @Nullable NormalizedNodeContext getParent() {
        return this.parent;
    }

    YangInstanceIdentifier getPath() {
        return (this.parent == null ? YangInstanceIdentifier.empty() : this.parent.getPath()).node(this.node.getIdentifier());
    }

    DataSchemaContextNode<?> getSchema() {
        return this.schema;
    }

    NormalizedNodeContext createChild(NormalizedNode<?, ?> input) {
        DataSchemaNode mySchema;
        DataSchemaContextNode childSchema = this.schema.getChild(input.getIdentifier());
        if (childSchema == null && (mySchema = this.schema.getDataSchemaNode()) instanceof ListSchemaNode) {
            childSchema = ((DataSchemaContextNode)Verify.verifyNotNull((Object)this.schema.getChild(mySchema.getQName()))).getChild(input.getIdentifier());
        }
        Preconditions.checkArgument((childSchema != null ? 1 : 0) != 0, (String)"Failed to find schema for child %s", input);
        return new NormalizedNodeContext(this.getContextSupport(), childSchema, input, this);
    }

    Optional<NormalizedNodeContext> findChild(YangInstanceIdentifier.PathArgument arg) {
        return this.node instanceof DataContainerNode ? ((DataContainerNode)this.node).getChild(arg).map(this::createChild) : Optional.empty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    Optional<NormalizedNodeContext> findDescendant(YangInstanceIdentifier path) {
        if (path.isEmpty()) {
            return Optional.of(this);
        }
        NormalizedNodeContext ctxWalk = this;
        NormalizedNode dataWalk = this.node;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            Preconditions.checkArgument((boolean)(dataWalk instanceof DataContainerNode), (String)"Path %s refers beyond node %s", (Object)path, dataWalk);
            @Nullable Optional optChild = ((DataContainerNode)dataWalk).getChild(arg);
            if (!optChild.isPresent()) {
                return Optional.empty();
            }
            dataWalk = (NormalizedNode)optChild.get();
            ctxWalk = this.createChild(dataWalk);
        }
        return Optional.of(ctxWalk.createChild(dataWalk));
    }

    Iterator<NormalizedNodeContext> iterateChildren(DataContainerNode<?> data) {
        return Iterators.transform(((DataContainerNode)this.node).getValue().iterator(), this::createChild);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable Iterator<NormalizedNodeContext> iterateChildrenNamed(DataContainerNode<?> data, QName qname) {
        Collection collection;
        YangInstanceIdentifier.NodeIdentifier arg = new YangInstanceIdentifier.NodeIdentifier(qname);
        @Nullable Optional maybeChild = data.getChild((YangInstanceIdentifier.PathArgument)arg);
        if (!maybeChild.isPresent()) {
            return null;
        }
        NormalizedNode child = (NormalizedNode)maybeChild.get();
        if (child instanceof MapNode) {
            collection = ((MapNode)child).getValue();
        } else if (child instanceof LeafSetNode) {
            collection = ((LeafSetNode)child).getValue();
        } else {
            return Iterators.singletonIterator((Object)((Object)this.createChild(child)));
        }
        return Iterators.transform(collection.iterator(), this::createChild);
    }

    static NormalizedNodeContext cast(@Nullable Context context) {
        Verify.verify((boolean)(context instanceof NormalizedNodeContext));
        return (NormalizedNodeContext)context;
    }
}

