/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.jaxen.ConverterNamespaceContext;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenDocument;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeNavigator;
import org.opendaylight.yangtools.yang.data.jaxen.YangFunctionContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;

final class NormalizedNodeContextSupport
extends ContextSupport
implements SchemaContextProvider {
    private static final long serialVersionUID = 1L;
    private final NormalizedNodeContext root = NormalizedNodeContext.forRoot(this);

    private NormalizedNodeContextSupport(ConverterNamespaceContext context, NormalizedNodeNavigator navigator) {
        super((NamespaceContext)context, (FunctionContext)YangFunctionContext.getInstance(), (VariableContext)new SimpleVariableContext(), (Navigator)navigator);
    }

    static NormalizedNodeContextSupport create(JaxenDocument document, Converter<String, QNameModule> prefixes) {
        ConverterNamespaceContext context = new ConverterNamespaceContext(prefixes);
        NormalizedNodeNavigator navigator = new NormalizedNodeNavigator(context, document);
        return new NormalizedNodeContextSupport(context, navigator);
    }

    NormalizedNodeContext createContext(YangInstanceIdentifier path) {
        NormalizedNodeContext result = this.root;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            Optional node = NormalizedNodes.getDirectChild(result.getNode(), (YangInstanceIdentifier.PathArgument)arg);
            Preconditions.checkArgument((boolean)node.isPresent(), (String)"Node %s has no child %s", result.getNode(), (Object)arg);
            result = result.createChild((NormalizedNode)node.get());
        }
        return result;
    }

    public NormalizedNodeNavigator getNavigator() {
        return (NormalizedNodeNavigator)super.getNavigator();
    }

    public SchemaContext getSchemaContext() {
        return this.getNavigator().getSchemaContext();
    }
}

