/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jaxen.DefaultNavigator;
import org.jaxen.NamedAccessNavigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.jaxen.ConverterNamespaceContext;
import org.opendaylight.yangtools.yang.data.jaxen.JaxenDocument;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;

final class NormalizedNodeNavigator
extends DefaultNavigator
implements NamedAccessNavigator,
SchemaContextProvider {
    private static final long serialVersionUID = 1L;
    private static final Joiner JOINER = Joiner.on((String)" ").skipNulls();
    private final ConverterNamespaceContext namespaceContext;
    private final JaxenDocument document;

    NormalizedNodeNavigator(ConverterNamespaceContext context, JaxenDocument document) {
        this.namespaceContext = Objects.requireNonNull(context);
        this.document = document;
    }

    private static NormalizedNodeContext cast(Object context) {
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context node %s", (Object)context);
        return (NormalizedNodeContext)((Object)context);
    }

    private static NormalizedNode<?, ?> contextNode(Object context) {
        return NormalizedNodeNavigator.cast(context).getNode();
    }

    private QName resolveQName(NormalizedNode<?, ?> node, String prefix, String localName) {
        QNameModule module = prefix.isEmpty() ? node.getNodeType().getModule() : (QNameModule)this.namespaceContext.convert(prefix);
        return QName.create((QNameModule)module, (String)localName);
    }

    private static Map.Entry<QName, String> attribute(Object attr) {
        Verify.verify((boolean)(attr instanceof Map.Entry), (String)"Unhandled attribute %s", (Object)attr);
        return (Map.Entry)attr;
    }

    public String getElementNamespaceUri(Object element) {
        return NormalizedNodeNavigator.contextNode(element).getNodeType().getNamespace().toString();
    }

    public String getElementName(Object element) {
        return NormalizedNodeNavigator.contextNode(element).getNodeType().getLocalName();
    }

    public String getElementQName(Object element) {
        return this.namespaceContext.jaxenQName(NormalizedNodeNavigator.contextNode(element).getNodeType());
    }

    public String getAttributeNamespaceUri(Object attr) {
        return NormalizedNodeNavigator.attribute(attr).getKey().getNamespace().toString();
    }

    public String getAttributeName(Object attr) {
        return NormalizedNodeNavigator.attribute(attr).getKey().getLocalName();
    }

    public String getAttributeQName(Object attr) {
        return this.namespaceContext.jaxenQName(NormalizedNodeNavigator.attribute(attr).getKey());
    }

    public NormalizedNodeContext getDocumentNode(Object contextNode) {
        NormalizedNodeContext ctx = NormalizedNodeNavigator.cast(contextNode);
        while (ctx.getParent() != null) {
            ctx = ctx.getParent();
        }
        return ctx;
    }

    public boolean isDocument(Object object) {
        return NormalizedNodeNavigator.cast(object).getParent() == null;
    }

    public boolean isElement(Object object) {
        return object instanceof NormalizedNodeContext;
    }

    public boolean isAttribute(Object object) {
        return object instanceof Map.Entry;
    }

    public boolean isNamespace(Object object) {
        return false;
    }

    public boolean isComment(Object object) {
        return false;
    }

    public boolean isText(Object object) {
        return object instanceof String;
    }

    public boolean isProcessingInstruction(Object object) {
        return false;
    }

    public String getCommentStringValue(Object comment) {
        throw new UnsupportedOperationException();
    }

    public String getElementStringValue(Object element) {
        NormalizedNode<?, ?> node = NormalizedNodeNavigator.contextNode(element);
        if (node instanceof LeafNode || node instanceof LeafSetEntryNode) {
            Object value = node.getValue();
            if (value instanceof byte[]) {
                return Base64.getEncoder().encodeToString((byte[])value);
            }
            if (value instanceof Set) {
                return JOINER.join((Iterable)((Set)value));
            }
            if (value != null) {
                return String.valueOf(value);
            }
        }
        return "";
    }

    public String getAttributeStringValue(Object attr) {
        return NormalizedNodeNavigator.attribute(attr).getValue();
    }

    public String getNamespaceStringValue(Object ns) {
        throw new UnsupportedOperationException();
    }

    public String getTextStringValue(Object text) {
        return text.toString();
    }

    public String getNamespacePrefix(Object ns) {
        throw new UnsupportedOperationException();
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        throw new UnsupportedOperationException();
    }

    public Iterator<NormalizedNodeContext> getChildAxisIterator(Object contextNode) {
        NormalizedNodeContext ctx = NormalizedNodeNavigator.cast(contextNode);
        NormalizedNode<?, ?> node = ctx.getNode();
        return node instanceof DataContainerNode ? ctx.iterateChildren((DataContainerNode)node) : null;
    }

    public Iterator<NormalizedNodeContext> getChildAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        NormalizedNodeContext ctx = NormalizedNodeNavigator.cast(contextNode);
        NormalizedNode<?, ?> node = ctx.getNode();
        return node instanceof DataContainerNode ? ctx.iterateChildrenNamed((DataContainerNode)node, this.resolveQName(node, namespacePrefix, localName)) : null;
    }

    public Iterator<? extends Map.Entry<?, ?>> getAttributeAxisIterator(Object contextNode) {
        return null;
    }

    public Iterator<? extends Map.Entry<?, ?>> getAttributeAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        return null;
    }

    public Iterator<NormalizedNodeContext> getParentAxisIterator(Object contextNode) {
        NormalizedNodeContext parent = NormalizedNodeNavigator.cast(contextNode).getParent();
        return parent == null ? null : Iterators.singletonIterator((Object)((Object)parent));
    }

    public Iterator<NormalizedNodeContext> getAncestorAxisIterator(Object contextNode) throws UnsupportedAxisException {
        NormalizedNodeContext parent = NormalizedNodeNavigator.cast(contextNode).getParent();
        return parent == null ? null : new NormalizedNodeContextIterator(parent);
    }

    public Iterator<NormalizedNodeContext> getSelfAxisIterator(Object contextNode) throws UnsupportedAxisException {
        return Iterators.singletonIterator((Object)((Object)NormalizedNodeNavigator.cast(contextNode)));
    }

    public Iterator<NormalizedNodeContext> getAncestorOrSelfAxisIterator(Object contextNode) throws UnsupportedAxisException {
        return new NormalizedNodeContextIterator(NormalizedNodeNavigator.cast(contextNode));
    }

    public NormalizedNodeContext getParentNode(Object contextNode) throws UnsupportedAxisException {
        return NormalizedNodeNavigator.cast(contextNode).getParent();
    }

    public SchemaContext getSchemaContext() {
        return this.document.getSchemaContext();
    }

    JaxenDocument getDocument() {
        return this.document;
    }

    private static final class NormalizedNodeContextIterator
    extends UnmodifiableIterator<NormalizedNodeContext> {
        private NormalizedNodeContext next;

        NormalizedNodeContextIterator(NormalizedNodeContext initial) {
            this.next = Objects.requireNonNull(initial);
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public NormalizedNodeContext next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            NormalizedNodeContext ret = this.next;
            this.next = this.next.getParent();
            return ret;
        }
    }
}

