/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.jaxen;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.FunctionContext;
import org.jaxen.UnresolvableException;
import org.jaxen.XPathFunctionContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.jaxen.LeafrefXPathStringParsingPathArgumentBuilder;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeContextSupport;
import org.opendaylight.yangtools.yang.data.jaxen.NormalizedNodeNavigator;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.RegexUtils;

final class YangFunctionContext
implements FunctionContext {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Double DOUBLE_NAN = Double.NaN;
    private static final FunctionContext XPATH_FUNCTION_CONTEXT = new XPathFunctionContext(false);
    private static final YangFunctionContext INSTANCE = new YangFunctionContext();

    private YangFunctionContext() {
    }

    static YangFunctionContext getInstance() {
        return INSTANCE;
    }

    public Function getFunction(String namespaceURI, String prefix, String localName) throws UnresolvableException {
        if (prefix == null) {
            switch (localName) {
                case "bit-is-set": {
                    return YangFunctionContext::bitIsSet;
                }
                case "current": {
                    return YangFunctionContext::current;
                }
                case "deref": {
                    return YangFunctionContext::deref;
                }
                case "derived-from": {
                    return YangFunctionContext::derivedFrom;
                }
                case "derived-from-or-self": {
                    return YangFunctionContext::derivedFromOrSelf;
                }
                case "enum-value": {
                    return YangFunctionContext::enumValueFunction;
                }
                case "re-match": {
                    return YangFunctionContext::reMatch;
                }
            }
        }
        return XPATH_FUNCTION_CONTEXT.getFunction(namespaceURI, prefix, localName);
    }

    private static boolean bitIsSet(Context context, List<?> args) throws FunctionCallException {
        if (args == null || args.size() != 1) {
            throw new FunctionCallException("bit-is-set() takes two arguments: node-set nodes, string bit-name");
        }
        if (!(args.get(0) instanceof String)) {
            throw new FunctionCallException("Argument bit-name of bit-is-set() function should be a String");
        }
        String bitName = (String)args.get(0);
        NormalizedNodeContext currentNodeContext = YangFunctionContext.verifyContext(context);
        TypedDataSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(currentNodeContext);
        TypeDefinition nodeType = correspondingSchemaNode.getType();
        if (!(nodeType instanceof BitsTypeDefinition)) {
            return false;
        }
        Object nodeValue = currentNodeContext.getNode().getValue();
        if (!(nodeValue instanceof Set)) {
            return false;
        }
        BitsTypeDefinition bitsType = (BitsTypeDefinition)nodeType;
        Preconditions.checkState((boolean)YangFunctionContext.containsBit(bitsType, bitName), (String)"Bit %s does not belong to bits %s.", (Object)bitName, (Object)bitsType);
        return ((Set)nodeValue).contains(bitName);
    }

    private static NormalizedNodeContext current(Context context, List<?> args) throws FunctionCallException {
        if (!args.isEmpty()) {
            throw new FunctionCallException("current() takes no arguments.");
        }
        return YangFunctionContext.verifyContext(context);
    }

    private static NormalizedNode<?, ?> deref(Context context, List<?> args) throws FunctionCallException {
        if (!args.isEmpty()) {
            throw new FunctionCallException("deref() takes only one argument: node-set nodes.");
        }
        NormalizedNodeContext currentNodeContext = YangFunctionContext.verifyContext(context);
        TypedDataSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(currentNodeContext);
        Object nodeValue = currentNodeContext.getNode().getValue();
        TypeDefinition type = correspondingSchemaNode.getType();
        if (type instanceof InstanceIdentifierTypeDefinition) {
            return nodeValue instanceof YangInstanceIdentifier ? YangFunctionContext.getNodeReferencedByInstanceIdentifier((YangInstanceIdentifier)nodeValue, currentNodeContext) : null;
        }
        if (type instanceof LeafrefTypeDefinition) {
            PathExpression xpath = ((LeafrefTypeDefinition)type).getPathStatement();
            return YangFunctionContext.getNodeReferencedByLeafref(xpath, currentNodeContext, YangFunctionContext.getSchemaContext(currentNodeContext), correspondingSchemaNode, nodeValue);
        }
        return null;
    }

    private static boolean derivedFrom(Context context, List<?> args) throws FunctionCallException {
        Map.Entry<IdentitySchemaNode, IdentitySchemaNode> ids = YangFunctionContext.commonDerivedFrom("derived-from", context, args);
        return ids != null && YangFunctionContext.isAncestorOf(ids.getKey(), ids.getValue());
    }

    private static boolean derivedFromOrSelf(Context context, List<?> args) throws FunctionCallException {
        Map.Entry<IdentitySchemaNode, IdentitySchemaNode> ids = YangFunctionContext.commonDerivedFrom("derived-from-or-self", context, args);
        return ids != null && (ids.getValue().equals(ids.getKey()) || YangFunctionContext.isAncestorOf(ids.getKey(), ids.getValue()));
    }

    private static  @Nullable Map.Entry<IdentitySchemaNode, IdentitySchemaNode> commonDerivedFrom(String functionName, Context context, List<?> args) throws FunctionCallException {
        if (args == null || args.size() != 1) {
            throw new FunctionCallException(functionName + "() takes two arguments: node-set nodes, string identity");
        }
        if (!(args.get(0) instanceof String)) {
            throw new FunctionCallException("Argument 'identity' of " + functionName + "() function should be a String.");
        }
        NormalizedNodeContext currentNodeContext = YangFunctionContext.verifyContext(context);
        TypedDataSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(currentNodeContext);
        SchemaContext schemaContext = YangFunctionContext.getSchemaContext(currentNodeContext);
        return correspondingSchemaNode.getType() instanceof IdentityrefTypeDefinition && currentNodeContext.getNode().getValue() instanceof QName ? new AbstractMap.SimpleImmutableEntry<IdentitySchemaNode, IdentitySchemaNode>(YangFunctionContext.getIdentitySchemaNodeFromString((String)args.get(0), schemaContext, correspondingSchemaNode), YangFunctionContext.getIdentitySchemaNodeFromQName((QName)currentNodeContext.getNode().getValue(), schemaContext)) : null;
    }

    private static Object enumValueFunction(Context context, List<?> args) throws FunctionCallException {
        if (!args.isEmpty()) {
            throw new FunctionCallException("enum-value() takes one argument: node-set nodes.");
        }
        NormalizedNodeContext currentNodeContext = YangFunctionContext.verifyContext(context);
        TypedDataSchemaNode correspondingSchemaNode = YangFunctionContext.getCorrespondingTypedSchemaNode(currentNodeContext);
        TypeDefinition nodeType = correspondingSchemaNode.getType();
        if (!(nodeType instanceof EnumTypeDefinition)) {
            return DOUBLE_NAN;
        }
        Object nodeValue = currentNodeContext.getNode().getValue();
        if (!(nodeValue instanceof String)) {
            return DOUBLE_NAN;
        }
        EnumTypeDefinition enumerationType = (EnumTypeDefinition)nodeType;
        String enumName = (String)nodeValue;
        return YangFunctionContext.getEnumValue(enumerationType, enumName);
    }

    private static boolean reMatch(Context context, List<?> args) throws FunctionCallException {
        if (args == null || args.size() != 2) {
            throw new FunctionCallException("re-match() takes two arguments: string subject, string pattern.");
        }
        Object subject = args.get(0);
        if (!(subject instanceof String)) {
            throw new FunctionCallException("First argument of re-match() should be a String.");
        }
        Object pattern = args.get(1);
        if (!(pattern instanceof String)) {
            throw new FunctionCallException("Second argument of re-match() should be a String.");
        }
        return ((String)subject).matches(RegexUtils.getJavaRegexFromXSD((String)((String)pattern)));
    }

    private static boolean isAncestorOf(IdentitySchemaNode identity, IdentitySchemaNode descendant) {
        for (IdentitySchemaNode base : descendant.getBaseIdentities()) {
            if (!identity.equals(base) && !YangFunctionContext.isAncestorOf(identity, base)) continue;
            return true;
        }
        return false;
    }

    private static IdentitySchemaNode getIdentitySchemaNodeFromQName(QName identityQName, SchemaContext schemaContext) {
        Optional module = schemaContext.findModule(identityQName.getModule());
        Preconditions.checkArgument((boolean)module.isPresent(), (String)"Module for %s not found", (Object)identityQName);
        return YangFunctionContext.findIdentitySchemaNodeInModule((Module)module.get(), identityQName);
    }

    private static IdentitySchemaNode getIdentitySchemaNodeFromString(String identity, SchemaContext schemaContext, TypedDataSchemaNode correspondingSchemaNode) {
        List identityPrefixAndName = COLON_SPLITTER.splitToList((CharSequence)identity);
        Module module = (Module)schemaContext.findModule(correspondingSchemaNode.getQName().getModule()).get();
        if (identityPrefixAndName.size() == 2) {
            if (((String)identityPrefixAndName.get(0)).equals(module.getPrefix())) {
                return YangFunctionContext.findIdentitySchemaNodeInModule(module, QName.create((QNameModule)module.getQNameModule(), (String)((String)identityPrefixAndName.get(1))));
            }
            for (ModuleImport moduleImport : module.getImports()) {
                if (!((String)identityPrefixAndName.get(0)).equals(moduleImport.getPrefix())) continue;
                Module importedModule = (Module)schemaContext.findModule(moduleImport.getModuleName(), moduleImport.getRevision()).get();
                return YangFunctionContext.findIdentitySchemaNodeInModule(importedModule, QName.create((QNameModule)importedModule.getQNameModule(), (String)((String)identityPrefixAndName.get(1))));
            }
            throw new IllegalArgumentException(String.format("Cannot resolve prefix '%s' from identity '%s'.", identityPrefixAndName.get(0), identity));
        }
        if (identityPrefixAndName.size() == 1) {
            return YangFunctionContext.findIdentitySchemaNodeInModule(module, QName.create((QNameModule)module.getQNameModule(), (String)((String)identityPrefixAndName.get(0))));
        }
        throw new IllegalArgumentException(String.format("Malformed identity argument: %s.", identity));
    }

    private static IdentitySchemaNode findIdentitySchemaNodeInModule(Module module, QName identityQName) {
        for (IdentitySchemaNode id : module.getIdentities()) {
            if (!identityQName.equals((Object)id.getQName())) continue;
            return id;
        }
        throw new IllegalArgumentException(String.format("Identity %s does not have a corresponding identity schema node in the module %s.", identityQName, module));
    }

    private static NormalizedNode<?, ?> getNodeReferencedByInstanceIdentifier(YangInstanceIdentifier path, NormalizedNodeContext currentNodeContext) {
        List relPath;
        Optional possibleNode;
        NormalizedNodeNavigator navigator = (NormalizedNodeNavigator)currentNodeContext.getNavigator();
        NormalizedNode<?, ?> rootNode = navigator.getDocument().getRootNode();
        List pathArguments = path.getPathArguments();
        if (((YangInstanceIdentifier.PathArgument)pathArguments.get(0)).getNodeType().equals((Object)rootNode.getNodeType()) && (possibleNode = NormalizedNodes.findNode(rootNode, relPath = pathArguments.subList(1, pathArguments.size()))).isPresent()) {
            return (NormalizedNode)possibleNode.get();
        }
        return null;
    }

    private static NormalizedNode<?, ?> getNodeReferencedByLeafref(PathExpression xpath, NormalizedNodeContext currentNodeContext, SchemaContext schemaContext, TypedDataSchemaNode correspondingSchemaNode, Object nodeValue) {
        NormalizedNode<?, ?> referencedNode;
        NormalizedNode<?, ?> normalizedNode = referencedNode = xpath.isAbsolute() ? YangFunctionContext.getNodeReferencedByAbsoluteLeafref(xpath, currentNodeContext, schemaContext, correspondingSchemaNode) : YangFunctionContext.getNodeReferencedByRelativeLeafref(xpath, currentNodeContext, schemaContext, correspondingSchemaNode);
        if (referencedNode instanceof LeafSetNode) {
            return YangFunctionContext.getReferencedLeafSetEntryNode((LeafSetNode)referencedNode, nodeValue);
        }
        if (referencedNode instanceof LeafNode && referencedNode.getValue().equals(nodeValue)) {
            return referencedNode;
        }
        return null;
    }

    private static NormalizedNode<?, ?> getNodeReferencedByAbsoluteLeafref(PathExpression xpath, NormalizedNodeContext currentNodeContext, SchemaContext schemaContext, TypedDataSchemaNode correspondingSchemaNode) {
        List relPath;
        Optional possibleNode;
        LeafrefXPathStringParsingPathArgumentBuilder builder = new LeafrefXPathStringParsingPathArgumentBuilder(xpath.getOriginalString(), schemaContext, correspondingSchemaNode, currentNodeContext);
        Object pathArguments = builder.build();
        NormalizedNodeNavigator navigator = (NormalizedNodeNavigator)currentNodeContext.getNavigator();
        NormalizedNode<?, ?> rootNode = navigator.getDocument().getRootNode();
        if (((YangInstanceIdentifier.PathArgument)pathArguments.get(0)).getNodeType().equals((Object)rootNode.getNodeType()) && (possibleNode = NormalizedNodes.findNode(rootNode, relPath = pathArguments.subList(1, pathArguments.size()))).isPresent()) {
            return (NormalizedNode)possibleNode.get();
        }
        return null;
    }

    private static NormalizedNode<?, ?> getNodeReferencedByRelativeLeafref(PathExpression xpath, NormalizedNodeContext currentNodeContext, SchemaContext schemaContext, TypedDataSchemaNode correspondingSchemaNode) {
        NormalizedNodeContext relativeNodeContext = currentNodeContext;
        StringBuilder xPathStringBuilder = new StringBuilder(xpath.getOriginalString());
        while (xPathStringBuilder.indexOf("../") == 0) {
            xPathStringBuilder.delete(0, 3);
            relativeNodeContext = relativeNodeContext.getParent();
        }
        xPathStringBuilder.insert(0, '/');
        LeafrefXPathStringParsingPathArgumentBuilder builder = new LeafrefXPathStringParsingPathArgumentBuilder(xPathStringBuilder.toString(), schemaContext, correspondingSchemaNode, currentNodeContext);
        Object pathArguments = builder.build();
        NormalizedNode<?, ?> relativeNode = relativeNodeContext.getNode();
        Optional possibleNode = NormalizedNodes.findNode(relativeNode, (Iterable)pathArguments);
        if (possibleNode.isPresent()) {
            return (NormalizedNode)possibleNode.get();
        }
        return null;
    }

    private static LeafSetEntryNode<?> getReferencedLeafSetEntryNode(LeafSetNode<?> referencedNode, Object currentNodeValue) {
        for (LeafSetEntryNode entryNode : referencedNode.getValue()) {
            if (!currentNodeValue.equals(entryNode.getValue())) continue;
            return entryNode;
        }
        return null;
    }

    private static boolean containsBit(BitsTypeDefinition bitsType, String bitName) {
        for (BitsTypeDefinition.Bit bit : bitsType.getBits()) {
            if (!bitName.equals(bit.getName())) continue;
            return true;
        }
        return false;
    }

    private static int getEnumValue(EnumTypeDefinition enumerationType, String enumName) {
        for (EnumTypeDefinition.EnumPair enumPair : enumerationType.getValues()) {
            if (!enumName.equals(enumPair.getName())) continue;
            return enumPair.getValue();
        }
        throw new IllegalStateException(String.format("Enum %s does not belong to enumeration %s.", enumName, enumerationType));
    }

    private static SchemaContext getSchemaContext(NormalizedNodeContext normalizedNodeContext) {
        ContextSupport contextSupport = normalizedNodeContext.getContextSupport();
        Verify.verify((boolean)(contextSupport instanceof NormalizedNodeContextSupport), (String)"Unhandled context support %s", contextSupport.getClass());
        return ((NormalizedNodeContextSupport)contextSupport).getSchemaContext();
    }

    private static TypedDataSchemaNode getCorrespondingTypedSchemaNode(NormalizedNodeContext currentNodeContext) {
        DataSchemaNode schemaNode = currentNodeContext.getSchema().getDataSchemaNode();
        Preconditions.checkState((boolean)(schemaNode instanceof TypedDataSchemaNode), (String)"Node %s must be a leaf or a leaf-list.", currentNodeContext.getNode());
        return (TypedDataSchemaNode)schemaNode;
    }

    private static NormalizedNodeContext verifyContext(Context context) {
        Verify.verify((boolean)(context instanceof NormalizedNodeContext), (String)"Unhandled context %s", context.getClass());
        return (NormalizedNodeContext)context;
    }
}

