/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.spi.DeleteLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.EmptyDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.NormalizedNodeDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.RecursiveDeleteCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.RecursiveReplaceCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.RecursiveUnmodifiedCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.RecursiveWriteCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.ReplaceLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.UnmodifiedLeafCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.WriteLeafCandidateNode;

@Beta
public final class DataTreeCandidateNodes {
    private DataTreeCandidateNodes() {
    }

    public static @NonNull DataTreeCandidateNode empty(YangInstanceIdentifier.PathArgument identifier) {
        return new EmptyDataTreeCandidateNode(identifier);
    }

    public static @NonNull DataTreeCandidateNode unmodified(NormalizedNode node) {
        if (node instanceof DistinctNodeContainer) {
            return new RecursiveUnmodifiedCandidateNode((DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode>)((DistinctNodeContainer)node));
        }
        return new UnmodifiedLeafCandidateNode(node);
    }

    public static @NonNull DataTreeCandidateNode written(NormalizedNode node) {
        return new NormalizedNodeDataTreeCandidateNode(node);
    }

    public static @NonNull Collection<DataTreeCandidateNode> containerDelta(@Nullable DistinctNodeContainer<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument, NormalizedNode> oldData, @Nullable DistinctNodeContainer<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument, NormalizedNode> newData) {
        if (newData == null) {
            return oldData == null ? ImmutableList.of() : Collections2.transform((Collection)oldData.body(), DataTreeCandidateNodes::deleteNode);
        }
        if (oldData == null) {
            return Collections2.transform((Collection)newData.body(), DataTreeCandidateNodes::writeNode);
        }
        ArrayList<DataTreeCandidateNode> result = new ArrayList<DataTreeCandidateNode>();
        for (NormalizedNode child : newData.body()) {
            NormalizedNode oldChild = oldData.childByArg(child.name());
            DataTreeCandidateNode node = oldChild != null ? DataTreeCandidateNodes.replaceNode(oldChild, child) : DataTreeCandidateNodes.writeNode(child);
            result.add(node);
        }
        for (NormalizedNode child : oldData.body()) {
            if (newData.childByArg(child.name()) != null) continue;
            result.add(DataTreeCandidateNodes.deleteNode(child));
        }
        return result;
    }

    public static @Nullable DataTreeCandidateNode containerDelta(@Nullable DistinctNodeContainer<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument, NormalizedNode> oldData, @Nullable DistinctNodeContainer<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument, NormalizedNode> newData, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.PathArgument child) {
        NormalizedNode newChild = DataTreeCandidateNodes.getChild(newData, child);
        NormalizedNode oldChild = DataTreeCandidateNodes.getChild(oldData, child);
        if (oldChild != null) {
            return newChild != null ? DataTreeCandidateNodes.replaceNode(oldChild, newChild) : DataTreeCandidateNodes.deleteNode(oldChild);
        }
        if (newChild != null) {
            return DataTreeCandidateNodes.writeNode(newChild);
        }
        return null;
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        switch (node.modificationType()) {
            case DELETE: {
                cursor.delete(node.name());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(node.name());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.childNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(node.name(), (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.modificationType());
            }
        }
    }

    public static void applyRootedNodeToCursor(DataTreeModificationCursor cursor, YangInstanceIdentifier rootPath, DataTreeCandidateNode node) {
        switch (node.modificationType()) {
            case DELETE: {
                cursor.delete(rootPath.getLastPathArgument());
                break;
            }
            case SUBTREE_MODIFIED: {
                cursor.enter(rootPath.getLastPathArgument());
                AbstractNodeIterator iterator = new ExitingNodeIterator(null, node.childNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            case WRITE: {
                cursor.write(rootPath.getLastPathArgument(), (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.modificationType());
            }
        }
    }

    public static void applyRootToCursor(DataTreeModificationCursor cursor, DataTreeCandidateNode node) {
        switch (node.modificationType()) {
            case DELETE: {
                throw new IllegalArgumentException("Can not delete root.");
            }
            case SUBTREE_MODIFIED: 
            case WRITE: {
                AbstractNodeIterator iterator = new RootNonExitingIterator(node.childNodes().iterator());
                while ((iterator = iterator.next(cursor)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.modificationType());
            }
        }
    }

    private static @Nullable NormalizedNode getChild(DistinctNodeContainer<YangInstanceIdentifier.PathArgument, ?> container, YangInstanceIdentifier.PathArgument identifier) {
        return container == null ? null : container.childByArg(identifier);
    }

    private static @NonNull DataTreeCandidateNode deleteNode(NormalizedNode data) {
        if (data instanceof DistinctNodeContainer) {
            return new RecursiveDeleteCandidateNode((DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode>)((DistinctNodeContainer)data));
        }
        return new DeleteLeafCandidateNode(data);
    }

    private static @NonNull DataTreeCandidateNode replaceNode(NormalizedNode oldData, NormalizedNode newData) {
        if (oldData instanceof DistinctNodeContainer) {
            return new RecursiveReplaceCandidateNode((DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode>)((DistinctNodeContainer)oldData), (DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode>)((DistinctNodeContainer)newData));
        }
        return new ReplaceLeafCandidateNode(oldData, newData);
    }

    private static @NonNull DataTreeCandidateNode writeNode(NormalizedNode data) {
        if (data instanceof DistinctNodeContainer) {
            return new RecursiveWriteCandidateNode((DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode>)((DistinctNodeContainer)data));
        }
        return new WriteLeafCandidateNode(data);
    }

    private static final class ExitingNodeIterator
    extends AbstractNodeIterator {
        private final AbstractNodeIterator parent;

        ExitingNodeIterator(AbstractNodeIterator parent, Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
            this.parent = parent;
        }

        @Override
        AbstractNodeIterator getParent() {
            return this.parent;
        }

        @Override
        void exitNode(DataTreeModificationCursor cursor) {
            cursor.exit();
        }
    }

    private static abstract class AbstractNodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;

        AbstractNodeIterator(Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
        }

        final AbstractNodeIterator next(DataTreeModificationCursor cursor) {
            block6: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                switch (node.modificationType()) {
                    case DELETE: {
                        cursor.delete(node.name());
                        continue block6;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case DISAPPEARED: {
                        Collection children = node.childNodes();
                        if (children.isEmpty()) continue block6;
                        cursor.enter(node.name());
                        return new ExitingNodeIterator(this, children.iterator());
                    }
                    case UNMODIFIED: {
                        continue block6;
                    }
                    case WRITE: {
                        cursor.write(node.name(), (NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported modification " + node.modificationType());
            }
            this.exitNode(cursor);
            return this.getParent();
        }

        abstract @Nullable AbstractNodeIterator getParent();

        abstract void exitNode(DataTreeModificationCursor var1);
    }

    private static final class RootNonExitingIterator
    extends AbstractNodeIterator {
        RootNonExitingIterator(Iterator<DataTreeCandidateNode> iterator) {
            super(iterator);
        }

        @Override
        void exitNode(DataTreeModificationCursor cursor) {
        }

        @Override
        AbstractNodeIterator getParent() {
            return null;
        }
    }
}

