/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

final class NormalizedNodeDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final NormalizedNode data;

    NormalizedNodeDataTreeCandidateNode(@NonNull NormalizedNode data) {
        this.data = Objects.requireNonNull(data);
    }

    public YangInstanceIdentifier.PathArgument name() {
        return this.data.name();
    }

    public ModificationType modificationType() {
        return ModificationType.WRITE;
    }

    public NormalizedNode dataBefore() {
        return null;
    }

    public NormalizedNode dataAfter() {
        return this.data;
    }

    public Collection<DataTreeCandidateNode> childNodes() {
        NormalizedNode normalizedNode = this.data;
        if (normalizedNode instanceof DistinctNodeContainer) {
            DistinctNodeContainer container = (DistinctNodeContainer)normalizedNode;
            return Collections2.transform((Collection)container.body(), input -> input == null ? null : new NormalizedNodeDataTreeCandidateNode((NormalizedNode)input));
        }
        return ImmutableList.of();
    }

    public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
        NormalizedNode normalizedNode = this.data;
        if (normalizedNode instanceof DistinctNodeContainer) {
            DistinctNodeContainer container = (DistinctNodeContainer)normalizedNode;
            NormalizedNode child = container.childByArg(childName);
            return child != null ? new NormalizedNodeDataTreeCandidateNode(child) : null;
        }
        return null;
    }
}

