/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.base.Verify;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

class TerminalDataTreeCandidateNode
implements DataTreeCandidateNode {
    private ModificationType modificationType;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument name;
    private final NormalizedNode before;
    private NormalizedNode after;
    private final HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode> childNodes = new HashMap();
    private TerminalDataTreeCandidateNode parentNode;

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, NormalizedNode data, TerminalDataTreeCandidateNode parentNode) {
        this(identifier, data);
        this.parentNode = Objects.requireNonNull(parentNode);
    }

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, NormalizedNode data) {
        this(identifier, ModificationType.UNMODIFIED, data, data);
    }

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument name, ModificationType modificationType, @Nullable NormalizedNode before, @Nullable NormalizedNode after) {
        this.name = name;
        this.modificationType = Objects.requireNonNull(modificationType);
        this.before = before;
        this.after = after;
    }

    public YangInstanceIdentifier.PathArgument name() {
        return this.name;
    }

    public Collection<DataTreeCandidateNode> childNodes() {
        return Collections.unmodifiableCollection(this.childNodes.values());
    }

    public DataTreeCandidateNode modifiedChild(YangInstanceIdentifier.PathArgument childIdentifier) {
        return this.childNodes.get(this.name);
    }

    public ModificationType modificationType() {
        return Objects.requireNonNull(this.modificationType);
    }

    public NormalizedNode dataAfter() {
        return this.after;
    }

    @Nullable NormalizedNode dataAfter(YangInstanceIdentifier.PathArgument id) {
        TerminalDataTreeCandidateNode child = this.node(id);
        return child != null ? child.dataAfter() : null;
    }

    public NormalizedNode dataBefore() {
        return this.before;
    }

    @Nullable NormalizedNode dataBefore(YangInstanceIdentifier.PathArgument id) {
        TerminalDataTreeCandidateNode child = this.node(id);
        return child != null ? child.dataBefore() : null;
    }

    void setAfter(NormalizedNode after) {
        this.after = after;
    }

    void addChildNode(TerminalDataTreeCandidateNode node) {
        this.childNodes.put(node.name(), node);
    }

    void setModification(YangInstanceIdentifier.PathArgument id, ModificationType modification) {
        this.getNode(id).orElseThrow(() -> new IllegalArgumentException("No node with " + id + " id was found")).setModification(modification);
    }

    private void setModification(ModificationType modification) {
        this.modificationType = Objects.requireNonNull(modification);
    }

    ModificationType getModification(YangInstanceIdentifier.PathArgument id) {
        return this.getNode(id).map(TerminalDataTreeCandidateNode::modificationType).orElse(ModificationType.UNMODIFIED);
    }

    void deleteNode(YangInstanceIdentifier.PathArgument id) {
        if (id != null) {
            this.getNode((YangInstanceIdentifier.PathArgument)id).orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$deleteNode$1(org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier$PathArgument ), ()Ljava/lang/IllegalArgumentException;)((YangInstanceIdentifier.PathArgument)id)).parentNode.deleteChild(id);
        } else {
            this.modificationType = ModificationType.UNMODIFIED;
        }
    }

    private void deleteChild(YangInstanceIdentifier.PathArgument id) {
        this.childNodes.remove(id);
    }

    final @Nullable TerminalDataTreeCandidateNode node(YangInstanceIdentifier.PathArgument id) {
        if (id == null) {
            return this;
        }
        if (this.childNodes.isEmpty()) {
            return null;
        }
        TerminalDataTreeCandidateNode childNode = this.childNodes.get(id);
        if (childNode != null) {
            return childNode;
        }
        return this.findNode(id).orElse(null);
    }

    final @NonNull Optional<TerminalDataTreeCandidateNode> getNode(YangInstanceIdentifier.PathArgument id) {
        return Optional.ofNullable(this.node(id));
    }

    void setData(YangInstanceIdentifier.PathArgument id, NormalizedNode node) {
        ((TerminalDataTreeCandidateNode)Verify.verifyNotNull((Object)this.node(id))).setAfter(node);
    }

    private @NonNull Optional<TerminalDataTreeCandidateNode> findNode(YangInstanceIdentifier.PathArgument id) {
        HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nodes = new HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>>();
        this.childNodes.forEach((childIdentifier, childNode) -> nodes.add(childNode.childNodes));
        return this.findNode(nodes, id);
    }

    private @NonNull Optional<TerminalDataTreeCandidateNode> findNode(Collection<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nodes, YangInstanceIdentifier.PathArgument id) {
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nextNodes = new HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>>();
        for (HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode> map : nodes) {
            if (map.containsKey(id)) {
                return Optional.ofNullable(map.get(id));
            }
            map.forEach((childIdentifier, childNode) -> nextNodes.add(childNode.childNodes));
        }
        return this.findNode(nextNodes, id);
    }

    private static /* synthetic */ IllegalArgumentException lambda$deleteNode$1(YangInstanceIdentifier.PathArgument id) {
        return new IllegalArgumentException("No node with " + id + " id was found");
    }
}

