/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;

final class NormalizedNodeDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final NormalizedNode data;

    NormalizedNodeDataTreeCandidateNode(@NonNull NormalizedNode data) {
        this.data = Objects.requireNonNull(data);
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.data.getIdentifier();
    }

    public Collection<DataTreeCandidateNode> getChildNodes() {
        if (this.data instanceof DistinctNodeContainer) {
            return Collections2.transform((Collection)((DistinctNodeContainer)this.data).body(), input -> input == null ? null : new NormalizedNodeDataTreeCandidateNode((NormalizedNode)input));
        }
        return ImmutableList.of();
    }

    public Optional<DataTreeCandidateNode> getModifiedChild(YangInstanceIdentifier.PathArgument childIdentifier) {
        if (this.data instanceof DistinctNodeContainer) {
            return ((DistinctNodeContainer)this.data).findChildByArg(childIdentifier).map(NormalizedNodeDataTreeCandidateNode::new);
        }
        return Optional.empty();
    }

    public ModificationType getModificationType() {
        return ModificationType.WRITE;
    }

    public Optional<NormalizedNode> getDataAfter() {
        return Optional.of(this.data);
    }

    public Optional<NormalizedNode> getDataBefore() {
        return Optional.empty();
    }
}

